% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.lmvar.R
\name{plot.lmvar}
\alias{plot.lmvar}
\title{Plot diagnostics for an 'lmvar' object}
\usage{
\method{plot}{lmvar}(x, which = c(1:3, 5), id.n = 3, cex.id = 0.75,
  show = TRUE, ...)
}
\arguments{
\item{x}{Object of class 'lmvar'}

\item{which}{Integer vector slecting which of the 5 plots is produced}

\item{id.n}{Integer, the number of 'extreme' observations that are labelled in the plots}

\item{cex.id}{Numeric, scale-factor for the size of the observation labels in the plots}

\item{show}{Boolean, if TRUE the number of the plot is shown in the plot-title and the name
of \code{x} is shown in the label of the x-axis.}

\item{...}{for compatibility with \code{\link[graphics]{plot}} generic}
}
\value{
There is no return value. The function only shows plots in the graphics output device.
}
\description{
This function produces 5 plots which should help to judge the goodness of an 'lmvar' fit.
}
\details{
The plots are intended to be a quick and easy way to get an impression of the
goodness-of-fit. The function is intended for an interactive R-session and users must hit <enter>
before each plot is deplayed. The following plots can be produced.
\enumerate{
\item A plot of the residuals \eqn{y - \mu} versus the fitted values \eqn{\mu}.
\item A QQ-plot, showing the z-score \eqn{(y - \mu) / \sigma} resulting from the fit versus
the z-score calculated from the sample quantiles. The sample quantiles are calculated as
\code{\link[stats]{ppoints}}(\eqn{n}) with \eqn{n} the number of obervations in \code{x}.
\item A histogram of the distribution of the quantiles of the response values. The quantiles
are calculated under the assumption that the response values are normally distributed with expected values
\eqn{\mu} and standard deviations \eqn{\sigma}.
\item A plot of the z-scores versus the fitted values.
\item A scale-location plot showing the square root of the absolute z-scores versus the fitted values.
}
If relevant, plots show the average y-value as a red line. This line is created by the function
\code{\link[graphics]{panel.smooth}}.
If relevant, plots show the expected average y-value as a dotted gray line.

To suppress labelling of observations in the plots, set \code{id.n} to zero or a negative
value. If \code{id.n}  is set to a value equal to or larger than the number of observations
in \code{x}, all points in the plots are labelled.
}
\examples{
if (interactive()){

# As example we use the dataset 'cats' from the library 'MASS'.
library(MASS)

# We regress the cats heart weight 'Hwt' onto its body weight 'Bwt'
X = model.matrix(~ Bwt - 1, cats)
fit = lmvar(cats$Hwt, X_mu = X, X_sigma = X)

# Display all plots
plot(fit)

# Display two plots that focus on the shape of the distribution
plot(fit, which = c(2, 3))

# Suppress plot number and name of the 'lmvar' object being plot in  plot 3
plot(fit, which = 3, show = FALSE)

# Label the 5 observations with the most extreme residuals in plot 1
plot(fit, which = 1, id.n = 5)

}
}
