% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.lmmspline-method.R
\name{plot.lmmspline}
\alias{plot.lmmspline}
\title{Plot of \code{lmmspline} object}
\usage{
\method{plot}{lmmspline}(x, y, smooth, data, time, mean, ...)
}
\arguments{
\item{x}{An object of class \code{lmmspline}.}

\item{y}{\code{character} or \code{numeric} value. Determining which feature should be plotted can be either the index or the name of the feature.}

\item{smooth}{an optional \code{logical} value. Default \code{FALSE}, if \code{TRUE} smooth representation of the fitted values.}

\item{data}{alternative \code{matrix} or \code{data.frame} containing the original data for visualisation purposes.}

\item{time}{alternative \code{numeric} indicating the sample time point. Vector of same length as row length of data for visualisation purposes.}

\item{mean}{alternative \code{logical} if the mean should be displayed. By default set to \code{TRUE}.}

\item{\ldots}{Additional arguments which are passed to \code{plot}.}
}
\value{
plot showing raw data, mean profile and fitted profile.
}
\description{
Plots the raw data, the mean and the fitted or derivative information of the \code{lmmspline} object.
}
\examples{
\dontrun{
data(kidneySimTimeGroup)
# running for samples in group 1
G1 <- which(kidneySimTimeGroup$group=="G1")
testLmmspline <- lmmSpline(data=kidneySimTimeGroup$data[G1,],
                 time=kidneySimTimeGroup$time[G1],
                 sampleID=kidneySimTimeGroup$sampleID[G1],keepModels=T)


plot(testLmmspline, y=2)
plot(testLmmspline, y=2, smooth=TRUE)
# Don't keep the models to improve memory usage
testLmmspline <- lmmSpline(data=kidneySimTimeGroup$data[G1,],
                 time=kidneySimTimeGroup$time[G1],
                 sampleID=kidneySimTimeGroup$sampleID[G1],keepModels=F)

#plot only the fitted values
plot(testLmmspline, y=2)
#plot fitted values with original data
plot(testLmmspline, y=2, data=kidneySimTimeGroup$data[G1,], time=kidneySimTimeGroup$time[G1])

}
}

