### $Id: TeachingII.q,v 1.1 1998/04/10 23:02:02 bates Exp $
### Split-plot analysis of covariance data for different teachers (uTeacher)
### using different methods (Method) on Students of different genders.
### Data set 5.7 in "SAS System for Mixed Models"
"TeachingII" <-
  structure(list(
  Method = structure(factor(c(1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
    3, 3, 3, 3, 3, 3), levels=1:3), class = "factor",
    .Label = c("1", "2", "3")),
Teacher = structure(factor(c(1, 1, 1, 1, 1, 1, 1, 
  1, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 
  4, 4, 4, 4, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 3, 
  3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 1, 1, 1, 1, 1, 1, 
  1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 
  4, 4, 4, 4, 4), levels=1:4), class = "factor",
  .Label = c("1", "2", "3", "4")),
Gender = structure(factor(c(1, 1, 1, 1, 2, 2, 
  2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 
  1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 
  1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 
  2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 
  1, 1, 2, 2, 2, 2), levels=1:2), .Label = c("f", "m"),
  class = "factor"),
IQ = c(89, 105, 108, 116, 95, 103, 91, 82, 83, 103, 123, 103, 118, 101, 
  101, 82, 115, 91, 109, 85, 98, 84, 91, 110, 120, 98, 99, 91, 
  80, 112, 105, 94, 97, 105, 120, 92, 91, 96, 95, 84, 105, 110, 
  98, 92, 104, 105, 82, 109, 141, 107, 116, 105, 93, 113, 92, 115, 
  112, 96, 103, 105, 111, 121, 87, 90, 87, 78, 117, 108, 92, 111, 
  126, 123, 126, 112, 108, 92, 95, 109, 115, 115, 102, 96, 113, 
  127, 112, 96, 114, 101, 95, 105, 95, 102, 80, 97, 114, 100),
score = c(54, 55, 54, 64, 59, 58, 42, 48,
  48, 56, 67, 54, 65, 65, 50, 55, 71, 
  66, 69, 59, 76, 64, 63, 74, 75, 60, 64, 59, 55, 70, 63, 62, 67, 
  74, 78, 69, 67, 64, 65, 52, 73, 78, 75, 65, 75, 78, 58, 75, 97, 
  68, 82, 86, 71, 82, 72, 77, 74, 76, 78, 77, 75, 86, 68, 74, 71, 
  71, 85, 87, 65, 72, 85, 78, 91, 80, 75, 65, 73, 73, 78, 71, 82, 
  72, 87, 91, 85, 68, 86, 78, 86, 91, 81, 85, 68, 81, 89, 87),
uTeacher = structure(ordered(c(1, 
  1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 
  3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 
  6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 
  9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 
  11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12), levels=1:12),
  class = c("ordered", "factor"),
  .Label = c("1/1", "1/2", "1/3", "1/4", "2/1", "2/2", 
    "2/3", "2/4", "3/1", "3/2", "3/3", "3/4"))),
class = c("nfnGroupedData", "nfGroupedData", "groupedData", "data.frame"),
row.names = 1:96,
formula = score ~ IQ | uTeacher,
labels = list(x = "Intelligence Quotient"),
inner = ~ Gender,
FUN = function (x) mean(x, na.rm = TRUE),
order.groups = TRUE)
