% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{regional_kendall}
\alias{regional_kendall}
\alias{test_statistic.regional_kendall}
\alias{p_value.regional_kendall}
\title{Regional Kendall Test for Trend}
\usage{
regional_kendall(
  x,
  t = seq_along(x),
  r = rep.int(1, length(x)),
  type = c("both", "increasing", "decreasing")
)

\method{test_statistic}{regional_kendall}(x, ...)

\method{p_value}{regional_kendall}(x, ...)
}
\arguments{
\item{x}{observations}

\item{t}{time index}

\item{r}{region index}

\item{type}{direction to test (both, increasing, or decreasing).}

\item{\dots}{further arguments passed to or from other methods.}
}
\description{
Performs Regional Kendall non-parametric test for trend.
}
\section{Methods (by generic)}{
\itemize{
\item \code{test_statistic}: Extracts Regional Kendall Z

\item \code{p_value}: Extract Regional Kendall p-value
}}

\references{
Gilbert, R.O., 1987. Statistical methods for environmental
pollution monitoring.
}
\seealso{
\code{\link{mann_kendall}}
}
