% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{adj_boxplot_stats}
\alias{adj_boxplot_stats}
\alias{adj_boxplot_stats.default}
\title{Adjusted Boxplot Statistics}
\usage{
adj_boxplot_stats(x, ...)

\method{adj_boxplot_stats}{default}(x, ...)
}
\arguments{
\item{x}{numeric vector}

\item{\dots}{further arguments passed to or from other methods.}
}
\value{
Numeric vector consisting of respectively the lower
  whisker/fence, the first quartile/hinge, the median, the third
  quartile/hinge, and the upper whisker/fence.
}
\description{
Adjusted boxplot statistics according to Hubert & Vandervieren (2008).
The upper whisker extends from the hinge to the largest value no further
than the upper fence. Similarly, the lower whisker extends from the hinge to
the smallest value no further than the lower fence. See Hubert &
Vandervieren (2008, p.5191, Eq.5).
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Adjusted Boxplot Statistics
}}

\examples{
adj_boxplot_stats(rlnorm(100))
}
\references{
Hubert, M., and E. Vandervieren, 2008.
An adjusted boxplot for skewed distributions.
Computational Statistics and Data Analysis 52:5186-5201
\doi{10.1016/j.csda.2007.11.008}
}
\seealso{
\code{\link{stat_adj_boxplot}}
}
