% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{power.wilcoxon}
\alias{power.wilcoxon}
\title{Power of Wilcoxon Test}
\usage{
\method{power}{wilcoxon}(x, n = 10, alpha = 0.05, n_sim = 1000, ...)
}
\arguments{
\item{x}{numeric vector}

\item{n}{number of samples of \code{x}}

\item{alpha}{significance level}

\item{n_sim}{number of Monte Carlo samples}

\item{\dots}{further arguments passed to or from other methods.}
}
\value{
power (numeric vector of length 1).
}
\description{
Estimates the power of a Wilcoxon test by means of 
Monte Carlo simulation.
}
\examples{
# continuous variable
x <- rnorm(n = 25, mean = 1, sd = 2)
w <- wilcoxon(x, mu = 2, type = "less")
p <- power(w, n = 10, alpha = 0.05)

# discrete variable
x <- rpois(n = 10, lambda = 50)
w <- wilcoxon(x, mu = 60, type = "less")
p <- power(w, n = 10, alpha = 0.05)
}
\references{
doi:10.1016/j.envpol.2019.02.030
}
