% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuse.R, R/mark.R
\name{fuse}
\alias{fuse}
\alias{fiss}
\alias{mark}
\title{Render Markdown, R Markdown, and R scripts}
\usage{
fuse(input, output = NULL, text = NULL, envir = parent.frame(), quiet = FALSE)

fiss(input, output = ".R", text = NULL)

mark(input, output = NULL, text = NULL, options = NULL, meta = list())
}
\arguments{
\item{input}{A character vector to provide the input file path or text. If
not provided, the \code{text} argument must be provided instead. The \code{input}
vector will be treated as a file path if it is a single string, and points
to an existing file or has a filename extension. In other cases, the vector
will be treated as the \code{text} argument input. To avoid ambiguity, if a
string should be treated as \code{text} input when it happens to be an existing
file path or has an extension, wrap it in \code{\link[=I]{I()}}, or simply use the \code{text}
argument instead.}

\item{output}{An output file path or a filename extension (e.g., \code{.html},
\code{.tex}, \code{.xml}, \code{.man}, \code{.markdown}, or \code{.txt}). In the latter case, the
output file path will use the extension on the same base filename as the
input file if the \code{input} is a file. If \code{output} is not character (e.g.,
\code{NA}), the results will be returned as a character vector instead of being
written to a file. If \code{output} is \code{NULL} or an extension, and the input is
a file path, the output file path will have the same base name as the input
file, with an extension corresponding to the output format. The output
format is retrieved from the first value in the \code{output} field of the YAML
metadata of the \code{input} (e.g., \code{litedown::html_format} will generate HTML
output). The \code{output} argument can also take an output format name
(possible values are \code{html}, \code{latex}, \code{xml}, \code{man}, \code{commonmark}, and
\code{text}). If no output format is detected or provided, the default is HTML.}

\item{text}{A character vector as the text input. By default, it is read from
the \code{input} file if provided.}

\item{envir}{An environment in which the code is to be evaluated. It can be
accessed via \code{\link[=fuse_env]{fuse_env()}} inside \code{\link[=fuse]{fuse()}}.}

\item{quiet}{If \code{TRUE}, do not show the progress bar. If \code{FALSE}, the
progress bar will be shown after a number of seconds, which can be set via
a global \link[=options]{option} \code{litedown.progress.delay} (the default is \code{2}).
THe progress bar output can be set via a global option
\code{litedown.progress.output} (the default is \code{\link[=stderr]{stderr()}}).}

\item{options}{Options to be passed to the renderer. See \code{\link[=markdown_options]{markdown_options()}}
for details. This argument can take either a character vector of the form
\code{"+option1 option2-option3"} (use \code{+} or a space to enable an option, and
\code{-} to disable an option), or a list of the form \code{list(option1 = value1, option2 = value2, ...)}. A string \code{"+option1"} is equivalent to
\code{list(option1 = TRUE)}, and \code{"-option2"} means \code{list(option2 = FALSE)}.
Options that do not take logical values must be specified via a list, e.g.,
\code{list(width = 30)}.}

\item{meta}{A named list of metadata. Elements in the metadata will be used
to fill out the template by their names and values, e.g., \code{list(title = ...)} will replace the \verb{$title$} variable in the template. See the Section
\dQuote{YAML metadata} \href{https://yihui.org/litedown/#sec:yaml-metadata}{in the documentation} for supported
variables.}
}
\value{
The output file path if output is written to a file, otherwise a
character vector of the rendered output (wrapped in \code{\link[xfun:raw_string]{xfun::raw_string()}}
for clearer printing).
}
\description{
The function \code{fuse()} extracts and runs code from code chunks
and inline code expressions in R Markdown, and interweaves the results with
the rest of text in the input, which is similar to what \code{\link[knitr:knit]{knitr::knit()}} and
\code{\link[rmarkdown:render]{rmarkdown::render()}} do. It also works on R scripts in a way similar to
\code{\link[knitr:spin]{knitr::spin()}}. The function \code{fiss()} extracts code from the input, and is
similar to \code{\link[knitr:knit]{knitr::purl()}}.

The function \code{mark()} renders Markdown to an output format via the
\pkg{commonmark} package.
}
\examples{
library(litedown)
doc = c("```{r}", "1 + 1", "```", "", "$\\\\pi$ = `{r} pi`.")
fuse(doc)
fuse(doc, ".tex")
fiss(doc)

mark(c("Hello _World_!", "", "Welcome to **litedown**."))
# if input appears to be a file path but should be treated as text, use I()
mark(I("This is *not* a file.md"))
# that's equivalent to
mark(text = "This is *not* a file.md")

# output to a file
(mark("_Hello_, **World**!", output = tempfile()))

# convert to other formats
mark("Hello _World_!", ".tex")
mark("Hello _**`World`**_!", "xml")
mark("Hello _**`World`**_!", "text")
}
\seealso{
\code{\link[=sieve]{sieve()}}, for the syntax of R scripts to be passed to \code{\link[=fuse]{fuse()}}.

The spec of GitHub Flavored Markdown:
\url{https://github.github.com/gfm/}
}
