% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semicolon_linter.R
\name{semicolon_linter}
\alias{semicolon_linter}
\title{Semicolon linter}
\usage{
semicolon_linter(allow_compound = FALSE, allow_trailing = FALSE)
}
\arguments{
\item{allow_compound}{Logical, default \code{FALSE}. If \code{TRUE}, "compound"
semicolons (e.g. as in \verb{x; y}, i.e., on the same line of code) are allowed.}

\item{allow_trailing}{Logical, default \code{FALSE}. If \code{TRUE}, "trailing"
semicolons (i.e., those that terminate lines of code) are allowed.}
}
\description{
Check that no semicolons terminate expressions.
}
\examples{
# will produce lints
lint(
  text = "a <- 1;",
  linters = semicolon_linter()
)

lint(
  text = "a <- 1; b <- 1",
  linters = semicolon_linter()
)

lint(
  text = "function() { a <- 1; b <- 1 }",
  linters = semicolon_linter()
)

# okay
lint(
  text = "a <- 1",
  linters = semicolon_linter()
)

lint(
  text = "a <- 1;",
  linters = semicolon_linter(allow_trailing = TRUE)
)

code_lines <- "a <- 1\nb <- 1"
writeLines(code_lines)
lint(
  text = code_lines,
  linters = semicolon_linter()
)

lint(
  text = "a <- 1; b <- 1",
  linters = semicolon_linter(allow_compound = TRUE)
)

code_lines <- "function() { \n  a <- 1\n  b <- 1\n}"
writeLines(code_lines)
lint(
  text = code_lines,
  linters = semicolon_linter()
)

}
\seealso{
\itemize{
\item \link{linters} for a complete list of linters available in lintr.
\item \url{https://style.tidyverse.org/syntax.html#semicolons}
}
}
\section{Tags}{
\link[=configurable_linters]{configurable}, \link[=default_linters]{default}, \link[=readability_linters]{readability}, \link[=style_linters]{style}
}
