% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineqGPlikelihoods.R
\name{lineqGPOptim}
\alias{lineqGPOptim}
\title{Gaussian Process Model Optimizations}
\usage{
lineqGPOptim(model, x0 = model$kernParam$par, eval_f = "logLik",
  lb = rep(0.01, length(par)), ub = rep(Inf, length(par)),
  opts = list(algorithm = "NLOPT_LD_MMA", print_level = 0, ftol_abs =
  0.001, maxeval = 50, check_derivatives = FALSE, parfixed = rep(FALSE,
  length(par)), estim.varnoise = FALSE, bounds.varnoise = c(0, Inf)),
  add.constr = FALSE, mcmc.opts = list(probe = "Genz", nb.mcmc = 1000),
  max.trials = 10, ...)
}
\arguments{
\item{model}{a list with the structure of the constrained Kriging model.}

\item{x0}{the initial values for the parameters to be optimized over.}

\item{eval_f}{a function to be minimized, with first argument the vector of parameters
over which minimization is to take place. It should return a scalar result.}

\item{lb}{a vector with lower bounds of the params. The params are forced to be positive.
See \code{\link{nloptr}}.}

\item{ub}{a vector with upper bounds of the params. See \code{\link{nloptr}}.}

\item{opts}{see \code{\link{nl.opts}}. Parameter \code{parfixed} indices of
fixed parameters to do not be optimised. If \code{estim.varnoise} is true, the
noise variance is estimated.}

\item{add.constr}{an optional logical. If \code{TRUE}, the inequality constraints are taken
into account in the optimisation.}

\item{mcmc.opts}{if \code{add.constr}, mcmc options passed to methods.}

\item{max.trials}{the value of the maximum number of trials when errors are produced by instabilities.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
An optimized \code{lineqGP} model.
}
\description{
Function for optimizations of \code{"lineqGP"} S3 class objects.
}
\section{Comments}{

This function has to be improved in the future for more stable procedures.
Cros-validation (CV) methods could be implemented in future versions.
}

\seealso{
\code{\link{nloptr}}
}
\author{
A. F. Lopez-Lopera.
}
