% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ls_import_data.R
\name{ls_import_data}
\alias{ls_import_data}
\title{Reading LimeSurvey data exported to R}
\usage{
ls_import_data(
  sid = NULL,
  path = NULL,
  datafile = NULL,
  dataPath = NULL,
  datafileRegEx = NULL,
  scriptfile = NULL,
  setVarNames = TRUE,
  setLabels = TRUE,
  convertToCharacter = FALSE,
  convertToFactor = FALSE,
  categoricalQuestions = NULL,
  massConvertToNumeric = TRUE,
  dataHasVarNames = TRUE,
  dataEncoding = "UTF-8-BOM",
  scriptEncoding = NULL,
  silent = limonaid::opts$get("silent")
)
}
\arguments{
\item{sid, path}{The easiest way to load data is to not rename the datafile
and script file downloaded from LimeSurvey (so that both contain the Survey
Identifier, the \code{sid}) and simply specify that \code{sid} and the path where both
files are stored.}

\item{datafile}{The path and filename of the file containing the data (comma
separated values).}

\item{dataPath, datafileRegEx}{Path containing datafiles: this can be used to
read multiple datafiles, if the data is split between those. This is useful
when downloading the entire datafile isn't possible because of server
restrictions, for example when the processing time for the script in
LimeSurvey that generates the datafiles is limited. In that case, the data
can be downloaded in portions, and specifying a path here enables reading
all datafiles in one go. Use the regular expression to indicate which files
in the path should be read.}

\item{scriptfile}{The path and filename of the file containing the R script
to import the data.}

\item{setVarNames, setLabels, convertToCharacter, convertToFactor}{Whether to
set variable names or labels, or convert to character or factor, using the
code isolated using the specified regular expression.}

\item{categoricalQuestions}{Which variables (specified using LimeSurvey
variable names) are considered categorical questions; for these, the script
to convert the variables to factors, as extracted from the LimeSurvey import
file, is applied.}

\item{massConvertToNumeric}{Whether to convert all variables to numeric
using \code{\link{massConvertToNumeric}}.}

\item{dataHasVarNames}{Whether the variable names are included as header
(first line) in the comma separated values file (data file).}

\item{dataEncoding, scriptEncoding}{The encoding of the files; can be used
to override the setting in the \code{limonaid} options (i.e. in \code{opts}) in the
\code{encoding} field (the default value is "\code{UTF-8}").}

\item{silent}{Whether to be silent or verbose ('chatty').}
}
\value{
The dataframe.
}
\description{
This function can be used to import files exported by LimeSurvey.
}
\details{
This function was intended to make importing data from LimeSurvey a bit
easier. The default settings used by LimeSurvey are not always convenient,
and this function provides a bit more control.
}
\examples{

\dontrun{
### Of course, you need valid LimeSurvey files. This is an example of
### what you'd do if you have them, assuming you specified that path
### containing the data in 'dataPath', the name of the datafile in
### 'dataFileName', the name of the script file in 'dataLoadScriptName',
### and that you only want variables 'informedConsent', 'gender', 'hasJob',
### 'currentEducation', 'prevEducation', and 'country' to be converted to
### factors.
dat <- limonaid::ls_import_data(
  datafile = file.path(dataPath, dataFileName),
  scriptfile = file.path(dataPath, dataLoadScriptName),
  categoricalQuestions = c('informedConsent',
                           'gender',
                           'hasJob',
                           'currentEducation',
                           'prevEducation',
                           'country')
);
}

}
