% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L_2S_ttest.R
\name{L_2S_ttest}
\alias{L_2S_ttest}
\title{Likelihood Supports for Independent Samples t Test}
\usage{
L_2S_ttest(data, group, veq=0, null=0, d=0.5, alt.2=NULL, L.int=2, verb=TRUE)
}
\arguments{
\item{data}{a (non-empty) numeric vector of data values.}

\item{group}{an integer vector the same length as data, coding for 2 groups.}

\item{veq}{whether variances are equal: 1 = Yes, 0 = No, default = 0.}

\item{null}{value for the null hypothesis, default = 0.}

\item{d}{Cohen's effect size, default = 0.5.}

\item{alt.2}{value for an alternative hypothesis, in units used for data, default = NULL.}

\item{L.int}{likelihood interval given as support values, e.g. 2 or 3, default = 2.}

\item{verb}{show output, default = TRUE.}
}
\value{
$obs.diff - the observed difference in means.

$df - degrees of freedom.

$var.eq - if not equal (0) then Welch's test used.

$alt.H1 - mean value according to specified d.

$alt.H2 - specified second hypothesis value.

$S_max - maximum support for observed mean difference against the null.

$S_10 - support for d versus null.

$S_12 - support for d versus specified second hypothesis.

$S_20 - support for second hypothesis versus the null.

$like.int - likelihood interval.

$L.int.spec - specified likelihood interval in units of support.

$null.value - null value

$t.val - t value for test against null.

$p.val - p value for test against null.

$d.obs - observed effect size (from null).
}
\description{
This function calculates several different supports for independent samples. Effect
size (Cohen's d) and a second alternative hypothesis value can be specified.
The maximum support is the support for the observed mean versus the null value.
The support for the specified d versus the null is also calculated. If a second
hypothesis value is specified (in units of the original measurements) then two
further supports are calculated: d versus 2nd alternative hypothesis, and 2nd
alternative hypothesis versus the null. The likelihood curve graphic with MLE and
specified hypothesis values is produced. Finally, the requested likelihood interval
is provided. The t, p and observed d values for the test against the null are given.
If variances are specified as unequal then uses Welch's test where
homogeneity of variance is not required.
}
\examples{
# using a variation on Gosset's original additional hours of sleep data, p 59
mysample <- c(0.7, -1.6, -0.2, -1.2, -0.1, 3.4, 3.7, 0.8, 0.0, 2.0)
treat <- rep(1:0,each=5)
L_2S_ttest(mysample, treat, veq=0, null=0, d=0.5, alt.2=2, L.int=2)

}
\references{
Cahusac, P.M.B. (2020) Evidence-Based Statistics, Wiley, ISBN : 978-1119549802

Baguley, T. (2012) Serious Stats, Palgrave Macmillan, ISBN: 978-0230577183

Edwards, A.W.F. (1992) Likelihood, Johns Hopkins Press, ISBN : 978-0801844430

Royall, R. M. (1997) Statistical Evidence: A Likelihood Paradigm, Chapman & Hall, ISBN : 978-0412044113

Royall, R. M. (2000). On the probability of observing misleading statistical evidence.
Journal of the American Statistical Association, 95, 760.
}
\keyword{Likelihood;}
\keyword{independent}
\keyword{interval}
\keyword{likelihood}
\keyword{samples}
\keyword{support;}
\keyword{t}
\keyword{test;}
