% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L_1way_RM_ANOVA.R
\name{L_1way_RM_ANOVA}
\alias{L_1way_RM_ANOVA}
\title{Likelihood Supports for One-way Repeated Measures ANOVA}
\usage{
L_1way_RM_ANOVA(dat, group, ID, contrast1=NULL, contrast2=NULL, verb=TRUE)
}
\arguments{
\item{dat}{a (non-empty) numeric vector of data values.}

\item{group}{a vector the same length as data, coding for k groups.}

\item{ID}{is an identifier for each case.}

\item{contrast1}{first contrast, default = NULL.}

\item{contrast2}{second contrast, default = NULL.}

\item{verb}{show output, default = TRUE.}
}
\value{
$S.12 - support for groups means hypothesis versus null.

$S.1m = support for first contrast versus means model.

$S.cont.12 - support for first versus second contrast.

$contrast1 - first contrast.

$contrast2 - second contrast.

$gp.means - group means.

$df - degrees of freedom for ANOVA.

$F.val - F value for overall analysis.

$P.val - p value for the overall analysis.

Fval.c1 - F value for the first contrast.

$df.1 - degrees of freedom for the contrast.

$P.val1 - p value for the contrast.
}
\description{
This function calculates support for the treatment means versus the null model,
support for the first contrast versus the group means model and the
support for the first versus the second contrast.
No correction is made for treatment degrees of freedom.
Also gives the F, p and partial eta-squared values for the overall analysis,
and F and p for the first contrast. Assumes sphericity.
}
\examples{
# sleep data example, p 97
dat <- c(0.7,	-1.6,	-0.2,	-1.2,	-0.1,	3.4,	3.7,	0.8,	0,	2,
1.9,	0.8,	1.1,	0.1,	-0.1,	4.4,	5.5,	1.6,	4.6,	3.4,
1.5,	1.4,	0.0,	-0.7,	0.5,	5.1,	5.7,	1.5,	4.7,	3.5)
treat <- gl(3,10,30)
patients <- gl(10,1,30)
contrast1 <- c(-1, 0, 1)  # linear
contrast2 <- c(-2, 1, 1)  # 1st vs treatments 2 & 3

m=L_1way_RM_ANOVA(dat, treat, patients, contrast1, contrast2)
m

}
\references{
Cahusac, P.M.B. (2020) Evidence-Based Statistics, Wiley, ISBN : 978-1119549802

Dixon P. The effective number of parameters in post hoc models. Behavior
Research Methods. 2013; 45(3):604.

Dixon P. The p-value fallacy and how to avoid it. Canadian Journal of
Experimental Psychology/Revue canadienne de psychologie expérimentale. 2003;
57(3):189.

Glover S, Dixon P. Likelihood ratios: a simple and flexible statistic for empirical
psychologists. Psychonomic Bulletin and Review. 2004; 11(5):791.
}
\keyword{ANOVA}
\keyword{Likelihood;}
\keyword{measures}
\keyword{repeated}
\keyword{support;}
