% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve.R
\name{is_solvable}
\alias{is_solvable}
\title{Is a given Lights Out board solvable?}
\usage{
is_solvable(board)
}
\arguments{
\item{board}{A \code{lightsout} board}
}
\value{
\code{TRUE} if the given board has a solution; \code{FALSE} otherwise.
}
\description{
Not every Lights Out configuration has a solution (this has been mathematically
proven). This function determines whether a given board has a solution or not.
}
\examples{
# The following board is solvable using the classic mode (only adjacent lights
# are toggled), but has no solution in the variant mode.
lights <- c(1, 1, 0,
            1, 0, 0,
            0, 0, 0 )
board_classic <- new_board(lights)
board_variant <- new_board(lights, classic = FALSE)
is_solvable(board_classic)
is_solvable(board_variant)
}
\seealso{
\code{\link[lightsout]{is_solved}}
\code{\link[lightsout]{solve_board}}
}

