% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viz_intraday.R
\name{plot_i_distance}
\alias{plot_i_distance}
\title{Plot distance over time.}
\usage{
plot_i_distance(person, avg_to_get_typical_day = TRUE, unit = "mi")
}
\arguments{
\item{person}{An instance of the Person class.}

\item{avg_to_get_typical_day}{Logical vector of length 1.  If TRUE, plot 
gives an aggregate of the variable over the course of a typical day.  If 
FALSE, plot gives the variable at every interval over the range specified
 when the Person object was instantiated.}

\item{unit}{The unit of distance, 'mi' by default, but can also specify 'km'}
}
\value{
NULL, but plot prints to screen.
}
\description{
Plot distance over time in units of either miles or kilometers.
}
\examples{
data(EX)
plot_i_distance(EX, FALSE)
plot_i_distance(EX, unit = "km")
}
