% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_match.R
\name{plot_matched}
\alias{plot_matched}
\title{Plot of matched pairs of detected and reference trees}
\usage{
plot_matched(lr, ld, matched, chm = NULL, plot_border = NULL, ...)
}
\arguments{
\item{lr}{data.frame or matrix. 3D coordinates (X Y Height) of reference 
positions}

\item{ld}{data.frame or matrix. 3D coordinates (X Y Height) of detected 
positions}

\item{matched}{data.frame. contains pair indices, typically returned by \code{\link{tree_matching}}}

\item{chm}{raster object. raster for background display}

\item{plot_border}{Spatialpolygon. plot boundaries for display}

\item{...}{Additional arguments to be used by \code{\link{plot}}}
}
\value{
no return
}
\description{
Plot of matched pairs of detected and reference trees
}
\examples{
# create reference and detected trees
ref_trees <- cbind(c(1, 4, 3, 4, 2), c(1, 1.5, 2, 3, 4), c(15, 18, 20, 10, 11))
def_trees <- cbind(c(2, 2, 4, 4), c(1, 3, 4, 1), c(16, 19, 9, 15))
#
# compute matching
match1 <- tree_matching(ref_trees, def_trees)
match2 <- tree_matching(ref_trees, def_trees, delta_ground = 2, h_prec = 0)

# 2D display of matching results
plot_matched(ref_trees, def_trees, match1, xlab = "X", ylab = "Y")
plot_matched(ref_trees, def_trees, match2, xlab = "X", ylab = "Y")
}
\seealso{
\code{\link{tree_matching}}, \code{\link{hist_detection}}
}
