% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aba.R
\name{ABApredict}
\alias{ABApredict}
\title{Mapping of ABA prediction models}
\usage{
ABApredict(aba.model, metrics.map, stratum = NULL, addError = FALSE)
}
\arguments{
\item{aba.model}{model returned by \code{\link{ABAmodel}} or \code{\link{ABAmodelCombineStrata}}}

\item{metrics.map}{RasterStack. metrics returned e.g by \code{\link[lidR]{grid_metrics}}}

\item{stratum}{string. indicates which layer of metrics.map contains the \code{stratum} in \code{modell}}

\item{addError}{boolean. indicates whether errors sampled from a normal distribution N(0, sigma(residuals)) should be added to fitted values; implemented only for \code{log} transformation case}
}
\value{
a raster of predictions obtained by applying the model \code{aba.model} to the observations in \code{metrics.map}
}
\description{
Applies calibrated area-based prediction models output of \code{\link{ABAmodel}} to a RasterStack of metrics to obtain a raster of predictions
}
\examples{
# load data
data(quatremontagnes)
# build model
ABA.model <- ABAmodel(quatremontagnes$G.m2.ha, quatremontagnes[,9:76],
transform = "boxcox")
# build example raster to apply model
quatremontagnes$X <- rep(1:8, 12)
quatremontagnes$Y <- rep(1:12, each = 8)
metrics.map <- raster::rasterFromXYZ(quatremontagnes[, c(2,3,9:76)])
predict.map <- lidaRtRee::ABApredict(ABA.model, metrics.map)

# plot map
raster::plot(predict.map, main = "predictions")
}
\seealso{
\link{ABAmodel} for model fitting and \link{ABAmodelCombineStrata} for combining stratified models, \link{cleanRaster} for applying spatial mask and value thresholds to a raster.
}
