% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.s3.R
\name{plot_3d}
\alias{plot_3d}
\alias{plot_dtm3d}
\alias{add_dtm3d}
\alias{add_treetops3d}
\alias{add_flightlines3d}
\title{Add a spatial object to a point cloud scene}
\usage{
plot_dtm3d(dtm, bg = "black", clear_artifacts = TRUE, ...)

add_dtm3d(x, dtm, ...)

add_treetops3d(x, ttops, z = "Z", ...)

add_flightlines3d(x, flightlines, z = "Z", ...)
}
\arguments{
\item{dtm}{An object of the class \code{RasterLayer}}

\item{bg}{The color for the background. Default is black.}

\item{clear_artifacts}{logical. It is a known and documented issue that 3D visualisation with
\code{rgl} displays artifacts. The points and lines are inaccurately positioned in the space and thus
the rendering may look false or weird. This is because \code{rgl} computes with single precision \code{float}.
To fix this, the objects are shifted to (0,0) to reduce the number of digits needed to represent
their coordinates. The drawback is that the objects are not plotted at their actual coordinates.}

\item{\dots}{Supplementary parameters for \link[rgl]{surface3d} or
\link[rgl:spheres]{spheres3d}.}

\item{x}{The output of the function plot used with a LAS object.}

\item{ttops}{A SpatialPointsDataFrame that contains tree tops coordinates.}

\item{z}{character. The name of the attribute that contains the height of the tree tops or of the flightlines.}

\item{flightlines}{A SpatialPointsDataFrame that contains flightlines coordinates.}
}
\description{
Add a \code{RasterLayer} object that represents a digital terrain model or a
\code{SpatialPointsDataFrame} that represents tree tops to a point cloud scene. To add elements
to a scene with a point cloud plotted with the function plot from lidR, the functions \code{add_*}
take as first argument the output of the plot function (see examples), because the plot function
does not plot the actual coordinates of the point cloud, but offsetted values. See function
\link[=plot]{plot} and its argument \code{clear_artifacts} for more details. It works only
with \code{rgl} i.e. \code{backend = "rgl"} which is the default.
}
\examples{
\dontrun{
LASfile <- system.file("extdata", "Topography.laz", package="lidR")
las = readLAS(LASfile, filter = "-keep_xy 273450 273600 5274450 5274600")

dtm = grid_terrain(las, algorithm = tin())
ttops <- find_trees(las, lmf(ws = 5))

plot_dtm3d(dtm)

x = plot(las)
add_dtm3d(x, dtm)
add_treetops3d(x, ttops)

library(magrittr)
plot(las) \%>\% add_dtm3d(dtm) \%>\% add_treetops3d(ttops)
}
}
