% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/las_check.R
\name{las_check}
\alias{las_check}
\title{Inspect a LAS object}
\usage{
las_check(las, print = TRUE, ...)
}
\arguments{
\item{las}{An object of class \link[lidR:LAS-class]{LAS} or \link[lidR:LAScatalog-class]{LAScatalog}.}

\item{print}{logical. By default, prints a report into standard ouptut. If \code{print = FALSE}
the functions returns a \code{list} with two elements named 'warnings' and 'errors' containing a
vector with the reported warnings and errors.}

\item{...}{Use \code{deep = TRUE} on a LAScatalog only. Instead of a shallow inspection it reads
all the files and performs a deep inspection.}
}
\value{
A list with two elements named \code{warnings} and \code{errors}. This list is returned
invisibly if \code{print = TRUE}. If \code{deep = TRUE} a nested list is returned with one element
per file.
}
\description{
Performs a deep inspection of a LAS or LAScatalog object and prints a report.\cr\cr
For a LAS object it checks:
\itemize{
\item if the point cloud is valid according to las specification
\item if the header is valid according to las specification
\item if the point cloud is in accordance with the header
\item if the point cloud has duplicated points and degenerated ground points
\item it the coordinate reference sytem is correctly recorded
\item if some pre-processing, such as normalization or ground filtering, is already done.
}
For a LAScatalog object it checks:
\itemize{
\item if the headers are consistent across files
\item if the files are overlapping
\item if some pre-processing, such as normalization, is already done.
}
For the pre-processing tests the function only makes an estimation and may not be correct.
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
las <- readLAS(LASfile)
las_check(las)
}
