% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voxel_metrics.r
\name{voxel_metrics}
\alias{voxel_metrics}
\title{Voxelize the space and compute metrics for each voxel}
\usage{
voxel_metrics(las, func, res = 1)
}
\arguments{
\item{las}{An object of class \code{LAS}.}

\item{func}{formula. An expression to be applied to each voxel (see also \link{grid_metrics}).}

\item{res}{numeric. The resolution of the voxels. \code{res = 1} for a 1x1x1 cubic voxels. Optionally
\code{res = c(1,2)} for non-cubic voxels (1x1x2 cuboid voxel).}
}
\value{
It returns a \code{data.table} containing the metrics for each voxel. The table
has the class \code{lasmetrics3d} enabling easier plotting.
}
\description{
This is a 3D version of \link{grid_metrics}. It creates a 3D matrix of voxels with a given resolution.
It creates a voxel from the cloud of points if there is at least one point in the voxel. For each voxel
the function allows computation of one or several derived metrics in the same way as the \link{grid_metrics}
functions. The function will dispatch the LiDAR data for each voxel in the user's function (see \link{grid_metrics}).
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
las = readLAS(LASfile)

# Cloud of points is voxelized with a 3-meter resolution and in each voxel
# the number of points is computed.
voxel_metrics(las, ~length(Z), 3)

# Cloud of points is voxelized with a 3-meter resolution and in each voxel
# the mean scan angle of points is computed.
voxel_metrics(las, ~mean(Intensity), 3)

\dontrun{
# Define your own metric function
myMetrics = function(i)
{
  ret = list(
     npoints = length(i),
     imean   = mean(i)
   )

   return(ret)
}

voxels = voxel_metrics(las, ~myMetrics(Intensity), 3)

plot(voxels, color = "imean", trim = 100)
#etc.
}
}
\seealso{
Other metrics: 
\code{\link{cloud_metrics}()},
\code{\link{grid_metrics}()},
\code{\link{hexbin_metrics}()},
\code{\link{point_metrics}()},
\code{\link{tree_metrics}()}
}
\concept{metrics}
