% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projection.r
\name{projection}
\alias{projection}
\alias{epsg}
\alias{epsg<-}
\alias{wkt}
\alias{wkt<-}
\alias{projection,LASheader-method}
\alias{epsg,LASheader-method}
\alias{epsg<-,LASheader-method}
\alias{wkt,LASheader-method}
\alias{wkt<-,LASheader-method}
\alias{projection<-,LAS-method}
\alias{epsg,LAS-method}
\alias{epsg<-,LAS-method}
\alias{wkt,LAS-method}
\alias{wkt<-,LAS-method}
\title{Get or set the projection of a LAS* object}
\usage{
epsg(object, ...)

epsg(object) <- value

wkt(object, ...)

wkt(object) <- value

\S4method{projection}{LASheader}(x, asText = TRUE)

\S4method{epsg}{LASheader}(object, ...)

\S4method{epsg}{LASheader}(object) <- value

\S4method{wkt}{LASheader}(object, ...)

\S4method{wkt}{LASheader}(object) <- value

\S4method{projection}{LAS}(x) <- value

\S4method{epsg}{LAS}(object)

\S4method{epsg}{LAS}(object) <- value

\S4method{wkt}{LAS}(object)

\S4method{wkt}{LAS}(object) <- value
}
\arguments{
\item{object, x}{An object of class LAS or eventually LASheader (regular users don't need to manipulate
LASheader objects).}

\item{...}{Unused.}

\item{value}{A \code{CRS} object or a \code{proj4string} string for function\code{projection}.
An EPSG code as integer for function \code{epsg}. A \code{WKT} string for function \code{wkt}.}

\item{asText}{logical. If TRUE, the projection is returned as text. Otherwise a CRS object is returned.}
}
\description{
Get or set the projection of a LAS* object with the function \code{projection}. Functions \code{epsg}
and \code{wkt} are reserved for advanced users (see details).
}
\details{
There are two ways to store the CRS of a point cloud in a LAS file:
\itemize{
\item Store an EPSG code (for LAS 1.0 to 1.4)
\item Store a WTK string (for LAS 1.4)
}
On the other hand, all spatial R packages use a \code{proj4string} to store the CRS. This is why
the CRS is duplicated in a LAS object. The information belongs within the header in a format that
can be written in a LAS file and in the slot \code{proj4string} in a format that can be understood
by R packages.
\itemize{
\item \code{projection<-}: updates the CRS from a \code{proj4string}. It updates the header either
with the EPSG code for LAS formats < 1.4 or with a WKT string for LAS format 1.4 and updates the
\code{proj4string} slot. This function should always be preferred.
\item \code{epsg<-}: updates the CRS from an EPSG code. It adds the EPSG code in the header and updates
the \code{proj4string} slot.
\item \code{wkt<-}: updates the CRS from a WKT string. It adds the WKT string in the header and updates
the \code{proj4string} slot.
\item \code{projection}: reads the \code{proj4string} from the \code{proj4string} slot.
\item \code{epsg}: reads the epsg code from the header.
\item \code{wkt}: reads the WKT string from the header.
}
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
las <- readLAS(LASfile)
crs <- sp::CRS("+init=epsg:26918")

projection(las)
projection(las) <- crs
}
