% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lasclip.r
\name{lasclip}
\alias{lasclip}
\alias{lasclipRectangle}
\alias{lasclipPolygon}
\alias{lasclipCircle}
\title{Clip LiDAR points}
\usage{
lasclip(x, geometry, ofile = "")

lasclipRectangle(x, xleft, ybottom, xright, ytop, ofile = "")

lasclipPolygon(x, xpoly, ypoly, ofile = "")

lasclipCircle(x, xcenter, ycenter, radius, ofile = "")
}
\arguments{
\item{x}{An object of class \code{LAS} or \code{LAScatalog}.}

\item{geometry}{a geometric object. Currently \code{Polygon} from \code{sp} is supported.}

\item{ofile}{character. Path to an output file (only with a \code{LAScatalog}).
If \code{ofile = ""} the result is loaded into R, otherwise the result is written to a
file while reading. This is much more memory efficient than loading into R first, then writing.}

\item{xleft}{scalar of left x position of rectangle.}

\item{ybottom}{scalar of bottom y position of rectangle.}

\item{xright}{scalar of right x position of rectangle.}

\item{ytop}{scalar of top y position of rectangle.}

\item{xpoly}{numerical array. x-coordinates of polygon.}

\item{ypoly}{numerical array. y-coordinates of polygon.}

\item{xcenter}{scalar of x disc center.}

\item{ycenter}{scalar of y disc center.}

\item{radius}{scalar of disc radius.}
}
\value{
An object of class \code{LAS} or NULL if the result is immediately written to a file.
}
\description{
Clip LiDAR points within a given geometry and convenient wrappers for most common geometries
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
las = readLAS(LASfile)
subset = lasclipRectangle(las, 684850, 5017850, 684900, 5017900)
plot(subset)
}
