% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_metrics.r
\name{tree_metrics}
\alias{tree_metrics}
\title{Compute metrics for each tree}
\usage{
tree_metrics(.las, func, debug = FALSE)
}
\arguments{
\item{.las}{An object of class \code{LAS}.}

\item{func}{The function to be applied to each tree.}

\item{debug}{logical. When facing a non trivial error, try \code{debug = TRUE}.}
}
\value{
Returns a \code{data.table} containing the metrics for each segmented tree.
}
\description{
Once the trees are segmented with \link{lastrees}, computes a series of descriptive statistics
defined by the user for each individual tree. The output is a table in which each line is a tree,
and each column is a metric. \code{tree_metrics} is similar to \link{lasmetrics} or \link{grid_metrics}
or \link{grid_metrics3d} or \link{grid_hexametrics}, except it computes metrics for each segmented tree.
}
\details{
The following existing functions contain a small set of pre-defined metrics:
\itemize{
\item{\link[lidR:stdmetrics]{stdmetrics_tree}}
} Users must write their own functions to create their own metrics. \code{tree_metrics} will
dispatch the LiDAR data for each segmented tree in the user-defined function. Functions
are defined without the need to considering each segmented tree i.e. only the point cloud (see examples).
}
\examples{
LASfile <- system.file("extdata", "Tree.laz", package="lidR")
las = readLAS(LASfile, filter = "-drop_z_below 0")

# segment trees (see lastrees)
lastrees(las, algorithm = "li2012")

# Max height for each tree
tree_metrics(las, mean(Z))

# Define your own new metrics
myMetrics = function(z, i)
{
  metrics = list(
     imean = mean(i),
     imax  = max(i),
     npoint = length(z)
   )

   return(metrics)
}

metrics = tree_metrics(las, myMetrics(Z, Intensity))

# predefined metrics (see ?stdmetrics)
metrics = tree_metrics(las, .stdtreemetrics)
}
