/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

#include <R.h>
#include <Rdefines.h>
#include <so.h>
#include "soc.h"

SEXP r_so_SimulationSubType_new()
{
	so_SimulationSubType *obj = so_SimulationSubType_new();
	if (!obj) {
		error("Failed to create so_SimulationSubType object");
	}
	return R_MakeExternalPtr(obj, R_NilValue, R_NilValue);
}

SEXP r_so_SimulationSubType_copy(SEXP self)
{
	so_SimulationSubType *obj = so_SimulationSubType_copy(R_ExternalPtrAddr(self));
	if (!obj) {
		error("Failed to copy so_SimulationSubType object");
	}
	return R_MakeExternalPtr(obj, R_NilValue, R_NilValue);
}

SEXP r_so_SimulationSubType_free(SEXP self)
{
	so_SimulationSubType_free(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_SimulationSubType_ref(SEXP self)
{
	so_SimulationSubType_ref(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_SimulationSubType_unref(SEXP self)
{
	so_SimulationSubType_unref(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_SimulationSubType_get_base(SEXP self)
{
	so_Table *child = so_SimulationSubType_get_base(R_ExternalPtrAddr(self));
	SEXP result = table2df(child);
	return result;
}
SEXP r_so_SimulationSubType_set_base(SEXP self, SEXP child)
{
	so_Table *table = df2table(child);
	so_SimulationSubType_set_base(R_ExternalPtrAddr(self), table);
	return R_NilValue;
}
SEXP r_so_SimulationSubType_get_name(SEXP self)
{
	char *value = so_SimulationSubType_get_name(R_ExternalPtrAddr(self));

	SEXP result;

	if (value) {
		result = PROTECT(NEW_STRING(1));
		SET_STRING_ELT(result, 0, mkChar(value));

		UNPROTECT(1);
	} else {
		result = R_NilValue;
	}
	return result;
}

SEXP r_so_SimulationSubType_set_name(SEXP self, SEXP string)
{
	char *c_string = (char *) CHAR(STRING_ELT(string, 0));
	int fail = so_SimulationSubType_set_name(R_ExternalPtrAddr(self), c_string);
	if (fail) {
		error("so_SimulationSubType_set_name failed");
	}

	return R_NilValue;
}

SEXP r_so_SimulationSubType_get_extFileNo(SEXP self)
{
	int *value = so_SimulationSubType_get_extFileNo(R_ExternalPtrAddr(self));

	SEXP result;

	if (value) {
		result = PROTECT(NEW_INTEGER(1));
		INTEGER(result)[0] = *value;

		UNPROTECT(1);
	} else {
		result = R_NilValue;
	}
	return result;
}

SEXP r_so_SimulationSubType_set_extFileNo(SEXP self, SEXP string)
{
	so_SimulationSubType_set_extFileNo(R_ExternalPtrAddr(self), INTEGER(string));

	return R_NilValue;
}

