/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#ifndef _SO_PRECISIONINDIVIDUALESTIMATES_H
#define _SO_PRECISIONINDIVIDUALESTIMATES_H

#include <so/Table.h>

/** \struct so_PrecisionIndividualEstimates
	 \brief A structure representing an SO/SOBlock/Estimation/PrecisionIndividualEstimates element
*/
typedef struct so_PrecisionIndividualEstimates so_PrecisionIndividualEstimates;

/** \memberof so_PrecisionIndividualEstimates
 * Create a new empty so_PrecisionIndividualEstimates structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_PrecisionIndividualEstimates_copy, so_PrecisionIndividualEstimates_free
 */
so_PrecisionIndividualEstimates *so_PrecisionIndividualEstimates_new();
/** \memberof so_PrecisionIndividualEstimates
 * Create a copy of a so_PrecisionIndividualEstimates structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_PrecisionIndividualEstimates_new
 */
so_PrecisionIndividualEstimates *so_PrecisionIndividualEstimates_copy(so_PrecisionIndividualEstimates *self);
/** \memberof so_PrecisionIndividualEstimates
 * Free all memory associated with a so_PrecisionIndividualEstimates structure and its children.
 * \param self - a pointer to the structure to free
 * \sa so_PrecisionIndividualEstimates_new
 */
void so_PrecisionIndividualEstimates_free(so_PrecisionIndividualEstimates *self);
void so_PrecisionIndividualEstimates_ref(so_PrecisionIndividualEstimates *self);
void so_PrecisionIndividualEstimates_unref(so_PrecisionIndividualEstimates *self);
/** \memberof so_PrecisionIndividualEstimates
 * Get the StandardDeviation element
 * \param self - pointer to a so_PrecisionIndividualEstimates
 * \return A pointer to the structure representing the StandardDeviation element
 * \sa so_PrecisionIndividualEstimates_set_StandardDeviation
 */
so_Table *so_PrecisionIndividualEstimates_get_StandardDeviation(so_PrecisionIndividualEstimates *self);
/** \memberof so_PrecisionIndividualEstimates
 * Get the PercentilesCI element
 * \param self - pointer to a so_PrecisionIndividualEstimates
 * \return A pointer to the structure representing the PercentilesCI element
 * \sa so_PrecisionIndividualEstimates_set_PercentilesCI
 */
so_Table *so_PrecisionIndividualEstimates_get_PercentilesCI(so_PrecisionIndividualEstimates *self);
/** \memberof so_PrecisionIndividualEstimates
 * Set the StandardDeviation element
 * \param self - pointer to a so_PrecisionIndividualEstimates
 * \param value - A pointer to a \a so_Table to set.
 * \sa so_PrecisionIndividualEstimates_get_StandardDeviation
 */
void so_PrecisionIndividualEstimates_set_StandardDeviation(so_PrecisionIndividualEstimates *self, so_Table *value);
/** \memberof so_PrecisionIndividualEstimates
 * Set the PercentilesCI element
 * \param self - pointer to a so_PrecisionIndividualEstimates
 * \param value - A pointer to a \a so_Table to set.
 * \sa so_PrecisionIndividualEstimates_get_PercentilesCI
 */
void so_PrecisionIndividualEstimates_set_PercentilesCI(so_PrecisionIndividualEstimates *self, so_Table *value);
/** \memberof so_PrecisionIndividualEstimates
 * Create a new StandardDeviation element and insert it into the so_PrecisionIndividualEstimates
 * \param self - pointer to a so_PrecisionIndividualEstimates
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Table *so_PrecisionIndividualEstimates_create_StandardDeviation(so_PrecisionIndividualEstimates *self);
/** \memberof so_PrecisionIndividualEstimates
 * Create a new PercentilesCI element and insert it into the so_PrecisionIndividualEstimates
 * \param self - pointer to a so_PrecisionIndividualEstimates
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Table *so_PrecisionIndividualEstimates_create_PercentilesCI(so_PrecisionIndividualEstimates *self);

#endif
