% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_dots.R
\name{nse_dots}
\alias{nse_dots}
\title{Convert dots to package names}
\usage{
nse_dots(..., keep_user = FALSE)
}
\arguments{
\item{...}{(Dots) Package names provided as bare names or strings (of length 1).
If a character vector is provided as the first argument, it will be used
and all other arguments in dots will be ignored.}

\item{keep_user}{(Logical) If \code{FALSE}, omit the username from a GitHub package reference.}
}
\value{
A character vector.
}
\description{
Convert dots to package names
}
\examples{
\dontrun{
nse_dots(dplyr, DesiQuintans/desiderata, keep_user = FALSE)

#> [1] "dplyr"   "desiderata"

nse_dots(dplyr, DesiQuintans/desiderata, keep_user = TRUE)

#> [1] "dplyr"   "DesiQuintans/desiderata"
}

}
