% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package_tools.R
\name{shelf}
\alias{shelf}
\title{Attach packages to the search path, installing them from CRAN, GitHub, or Bioconductor if needed}
\usage{
shelf(..., lib = lib_paths(), update_all = FALSE, quiet = FALSE,
  ask = TRUE, cran_repo = getOption("repos"),
  bioc_repo = character())
}
\arguments{
\item{...}{(Names) Packages as bare names. If the package is from GitHub,
include both the username and package name as UserName/package (see examples).}

\item{lib}{(Character) The path to the folder where new packages will be installed. The
folder will be added to the package search path. If the folder doesn't exist, you
will be prompted to create it if \code{ask = TRUE}, otherwise it will be silently
created. Can be an absolute or relative path. Tilde expansion is performed on the
input, but wildcard expansion (globbing) is not. If \code{lib} has more than one element,
only the first one will be kept. Defaults to the current library search path. See
the 'Details' section below for more information.}

\item{update_all}{(Logical) If \code{TRUE}, the packages will be re-installed even if they
are already in your library.}

\item{quiet}{(Logical) If \code{TRUE}, suppresses most warnings and messages.}

\item{ask}{(Logical) If \code{TRUE}, and \code{lib} points to a folder that doesn't exist, ask
before creating the folder. If \code{FALSE}, the folder will be created silently.}

\item{cran_repo}{(Character) In RStudio, a default CRAN repo can be set via
\emph{Options > Packages > Default CRAN Mirror}). Otherwise, provide the URL to CRAN or
one of its mirrors. If an invalid URL is given, defaults to https://cran.r-project.org.}

\item{bioc_repo}{(Character) If you use Bioconductor, you can set the repo URLs for it here.
Defaults to Bioconductor's defaults (view them with \code{BiocInstaller::biocinstallRepos()}).}
}
\value{
Invisibly returns a named logical vector, where the names are the packages
requested in \code{...} and \code{TRUE} means that the package was successfully installed
and attached.
}
\description{
Attach packages to the search path, installing them from CRAN, GitHub, or Bioconductor if needed
}
\details{
You may choose to organise your library into folders to hold packages for different
tasks or projects. If you specify a \code{lib} folder, it will be created (if needed) and
attached to the package search path. R will look for packages by working through the
package search path in order. You can view the folders that are on this path by
calling \code{lib_paths()} with no arguments.

If you specify a new \code{lib} and use the argument \code{update_all = TRUE} to force an
already-installed package to reinstall, a new copy of that package will be made in
\code{lib} and then loaded from there. This means that you can potentially have several
copies of the same package across many folders on your machine, each a different
version. This allows you to maintain a different library folder for different projects,
so that updated packages in Project B will not affect the package versions you rely on
for Project A.
}
\examples{
\donttest{
shelf(fortunes, DesiQuintans/emptyRpackage, cowsay, lib = tempdir(), update_all = TRUE)

# shelf() returns invisibly; bind its output to a variable or access the .Last.value.

print(.Last.value)

#> fortunes desiderata     cowsay 
#>     TRUE       TRUE       TRUE
}

}
