% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libname.R
\name{lib_load}
\alias{lib_load}
\title{Load a Library into the Workspace}
\usage{
lib_load(x, filter = NULL)
}
\arguments{
\item{x}{The data library to load.}

\item{filter}{One or more quoted strings to use as filters for the
data names to load into the workspace. For more than one filter string, 
pass them as a vector of strings. The filter string can be a full or 
partial name.  If using a partial name, use a wild-card character (*) 
to identify the missing portion. The match will be case-insensitive.}
}
\value{
The loaded data library.
}
\description{
The \code{lib_load} function loads a data library into
an environment. The environment used is associated with the library at 
the time it is created with the \code{\link{libname}} function.  
When the \code{lib_load} function is called, the data frames/tibbles 
will be loaded with <library>.<data set> syntax.  Loading the data frames
into the environment makes them easy to access and use in your program.

Note that the \code{lib_load} function is optional, and calling the function
is not needed to access data in the \code{libname}.  You may also access
data directly from the \code{libname} using the dollar sign ($) syntax.
}
\examples{
# Create temp directory
tmp <- tempdir()

# Save some data to temp directory for illustration purposes
saveRDS(iris, file.path(tmp, "iris.rds"))
saveRDS(ToothGrowth, file.path(tmp, "ToothGrowth.rds"))
saveRDS(PlantGrowth, file.path(tmp, "PlantGrowth.rds"))

# Create library
libname(dat, tmp)

# Load library into workspace
lib_load(dat)

# Examine workspace
ls()
# [1] "dat" "dat.iris" "dat.PlantGrowth" "dat.ToothGrowth" "tmp"

# Use some data
summary(dat.PlantGrowth)
summary(dat.ToothGrowth)

# Unload library
lib_unload(dat)

# Examine workspace again
ls()
# [1] "dat" "tmp"

# Clean up
lib_delete(dat)
}
\seealso{
\code{\link{lib_unload}} to unload the library.

Other lib: 
\code{\link{is.lib}()},
\code{\link{lib_add}()},
\code{\link{lib_copy}()},
\code{\link{lib_delete}()},
\code{\link{lib_export}()},
\code{\link{lib_info}()},
\code{\link{lib_path}()},
\code{\link{lib_remove}()},
\code{\link{lib_replace}()},
\code{\link{lib_size}()},
\code{\link{lib_sync}()},
\code{\link{lib_unload}()},
\code{\link{lib_write}()},
\code{\link{libname}()},
\code{\link{print.lib}()}
}
\concept{lib}
