% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionary.R
\name{dictionary}
\alias{dictionary}
\title{Create a Data Dictionary}
\usage{
dictionary(x)
}
\arguments{
\item{x}{The input library, data frame, or tibble.}
}
\description{
A function to create a data dictionary for a data frame,
a tibble, or a data library.  The function will generate a tibble of 
information about the data.  The tibble will contain the following columns:
\itemize{
  \item{\strong{Name:} The name of the data object.}
  \item{\strong{Column:} The name of the column.}
  \item{\strong{Class:} The class of the column.}
  \item{\strong{Label:} The value of the label attribute.}
  \item{\strong{Description:} A description applied to this column.}
  \item{\strong{Format:} The value of the format attribute.}
  \item{\strong{Width:} The value of the width attribute if any have been
  assigned.  If no width attributes have been assigned, 
  the max character width.}
  \item{\strong{Justify:} The justification or alignment attribute value.}
  \item{\strong{Rows:} The number of data rows.}
  \item{\strong{NAs:} The number of NA values in this column.}
}
}
\examples{
# Create temp directory
tmp <- tempdir()

# Create library
libname(dat, tmp)

# Add data to the library
lib_add(dat, beaver1)
lib_add(dat, iris)

# Examine the dictionary for the library
dictionary(dat)
# A tibble: 9 x 10
#   Name    Column       Class   Label Description Format Width Justify  Rows   NAs
#   <chr>   <chr>        <chr>   <lgl> <lgl>       <lgl>  <lgl> <lgl>   <int> <int>
# 1 beaver1 day          numeric NA    NA          NA     NA    NA        114     0
# 2 beaver1 time         numeric NA    NA          NA     NA    NA        114     0
# 3 beaver1 temp         numeric NA    NA          NA     NA    NA        114     0
# 4 beaver1 activ        numeric NA    NA          NA     NA    NA        114     0
# 5 iris    Sepal.Length numeric NA    NA          NA     NA    NA        150     0
# 6 iris    Sepal.Width  numeric NA    NA          NA     NA    NA        150     0
# 7 iris    Petal.Length numeric NA    NA          NA     NA    NA        150     0
# 8 iris    Petal.Width  numeric NA    NA          NA     NA    NA        150     0
# 9 iris    Species      factor  NA    NA          NA     NA    NA        150     0

# Clean up
lib_delete(dat)
}
\seealso{
\code{\link{libname}} to create a data library.  Also 
see the \code{\link{dsattr}} function to set attributes for your 
dataset from within a \code{\link{datastep}}.  To render attributes, 
see the \strong{fmtr} package.
}
