% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libname.R
\name{lib_copy}
\alias{lib_copy}
\title{Copy a Data Library}
\usage{
lib_copy(x, nm, directory_path)
}
\arguments{
\item{x}{The library to copy.}

\item{nm}{The unquoted variable name to hold the new library.}

\item{directory_path}{The path to copy the library to.}
}
\value{
The new library.
}
\description{
The \code{lib_copy} function copies a data library.  The 
function accepts a library and a destination path.  If the destination 
path does not exist, the function will attempt to create it.  

Note that
the copy will result in the current data in memory written to the new
destination directory.  If the library is loaded into the workspace, 
the workspace version will be considered the most current version, and
that is the version that will be copied.
}
\examples{
# Create temp directory
tmp <- tempdir()

# Create library
libname(dat1, tmp)

# Add dat to library
lib_add(dat1, mtcars, iris)

# Copy dat1 to dat2
lib_copy(dat1, dat2, file.path(tmp, "copy"))
# library 'dat2': 2 items
# - attributes: not loaded
# - path: C:\Users\User\AppData\Local\Temp\RtmpCSJ6Gc/copy
# - items:
#     Name Extension Rows Cols   Size        LastModified
# 1 mtcars       rds   32   11 7.5 Kb 2020-11-05 21:14:54
# 2   iris       rds  150    5 7.5 Kb 2020-11-05 21:14:54

# Clean up
lib_delete(dat1)
lib_delete(dat2)
}
\seealso{
Other lib: 
\code{\link{is.lib}()},
\code{\link{lib_add}()},
\code{\link{lib_delete}()},
\code{\link{lib_info}()},
\code{\link{lib_load}()},
\code{\link{lib_path}()},
\code{\link{lib_remove}()},
\code{\link{lib_replace}()},
\code{\link{lib_size}()},
\code{\link{lib_sync}()},
\code{\link{lib_unload}()},
\code{\link{lib_write}()},
\code{\link{libname}()},
\code{\link{print.lib}()}
}
\concept{lib}
