% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_Logger.R
\name{print.Logger}
\alias{print.Logger}
\alias{format.Logger}
\alias{print.ancestry}
\alias{format.ancestry}
\title{Print a Logger Object}
\usage{
\method{print}{Logger}(x, color = requireNamespace("crayon", quietly =
  TRUE), ...)

\method{format}{Logger}(x, color = FALSE, ...)

\method{print}{ancestry}(x, color = requireNamespace("crayon", quietly =
  TRUE), ...)

\method{format}{ancestry}(x, color = FALSE, ...)
}
\arguments{
\item{x}{any \R Object}

\item{color}{\code{TRUE} or \code{FALSE}: Output with color? Requires the Package
\strong{crayon}}

\item{...}{ignored}
}
\value{
\code{print()} returns \code{x} (invisibly), \code{format()} returns a \code{character} vector.
}
\description{
The \code{print()} method for Loggers displays the most important aspects of
the Logger.

You can also print just the \code{ancestry} of a Logger which can be accessed with
with \code{logger$ancestry()}. This returns a named \code{character} vector whose
names correspond to the names of the Loggers \code{logger} inherits from. The
\code{TRUE}/\code{FALSE} status of its elements correspond to the \code{propagate} values of
these Loggers.
}
\examples{
# print most important details of logger
print(lgr)
# print only the ancestry of a logger
lg <- get_logger("AegonV/Aerys/Rheagar/Aegon")
get_logger("AegonV/Aerys/Rheagar")$set_propagate(FALSE)

print(lg$ancestry)
unclass(lg$ancestry)
}
