% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimumContrast.R
\name{minimum.contrast.spatiotemporal}
\alias{minimum.contrast.spatiotemporal}
\title{minimum.contrast.spatiotemporal function}
\usage{
minimum.contrast.spatiotemporal(data, model, method = "g",
  spatial.dens = NULL, temporal.intens = NULL, power = 1,
  transform = NULL, spatial.startvals = NULL, temporal.interval = NULL,
  verbose = TRUE, ...)
}
\arguments{
\item{data}{An object of class 'stppp' from package 'lgcp'. Must be univariate i.e. have ' data$markformat=="none" '}

\item{model}{Assumed theoretical form of the spatial correlation function. Matches 'model' argument for 'CovarianceFct' in package RandomFields.}

\item{method}{Character string indicating which version of spatial minimum contrast to use: either "K" or "g".}

\item{spatial.dens}{An object of class 'spatialAtRisk', or a (possibly unnormalised) pixel image of class 'im', giving the underlying deterministic spatial density.}

\item{temporal.intens}{An object of class 'temporalAtRisk', giving the deterministic, possibly inhomogeneous, temporal intensity.}

\item{power}{Power to raise the functions to in the spatial contrast criterion. Default 1.}

\item{transform}{Transformation to apply to the spatial functions in the contrast criterion. Default no transformation.}

\item{spatial.startvals}{Starting values for 'optim' in minimising the contrast criterion in the order c(phi,sigma2). If NULL, the function automatically attempts to find suitable starting values, though no guarantee of 'optim' convergence can be given!}

\item{temporal.interval}{Defaults to c(0.1,10) if NULL. An interval of the form 'c(lowerlimit,upperlimit)' to be passed to 'optimise'. This is the interval in which the function will search for an optimal value for theta (the scale parameter for temporal dependence). Note that only the exponential covariance model is implemented for temporal dependence.}

\item{verbose}{Boolean. Whether or not to print function progress.}

\item{...}{Additional arguments to be passed to 'param' in evaluation of 'CovarianceFct' (need dependent upon 'model').}
}
\value{
Returned values are the minimum contrast estimates of phi, sigma^2 and theta, as well as the overall squared discrepancy between the parametric and nonparametric forms of the spatial function used corresponding to these estimates. (This can be useful in deciding between several different theoretical forms of the spatial correlation specified by 'model').
}
\description{
A function to provide minimum contrast (aka least squares) estimates of the spatial scale (phi), spatial variance (sigma^2) and temporal scale (theta) assuming an LGCP modelling framework
for spatiotemporal data. Currently only implemented for univariate (i.e. unmarked) spatiotemporal point patterns
}
\seealso{
\link{minimum.contrast}, link{chooseCellWidth}, \link{getpolyol}, \link{guessinterp}, \link{getZmat},
\link{addTemporalCovariates}, \link{lgcpPrior}, \link{lgcpInits}, \link{CovFunction}
\link{lgcpPredictSpatialPlusPars}, \link{lgcpPredictAggregateSpatialPlusPars}, \link{lgcpPredictSpatioTemporalPlusPars}, 
\link{lgcpPredictMultitypeSpatialPlusPars}
}
