## ----include=FALSE----------------------------------------------------------------------------------------------------
suppressPackageStartupMessages(library("lessR"))

## ----pivot, dataTable, echo=FALSE, out.width='92%', fig.align='center', out.extra='style="border-style: none"'--------
knitr::include_graphics(system.file("img", "pivot.png", package="lessR"))

## ---------------------------------------------------------------------------------------------------------------------
d <- Read("Employee")

## ---------------------------------------------------------------------------------------------------------------------
pivot(data=d, compute=mean, variable=Years, by=c(Dept, Gender))

## ---------------------------------------------------------------------------------------------------------------------
a <- pivot(d, mean, Salary, c(Dept, Gender))
a

## ---- fig.width=5-----------------------------------------------------------------------------------------------------
BarChart(Dept, Salary_mn, by=Gender, data=a)

## ---------------------------------------------------------------------------------------------------------------------
#Write("MyPivotTable", data=a, format="Excel")

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, c(mean, median, sd, IQR), Salary, Dept)

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, c(mean,sd,skew,kurtosis), Salary, Dept, digits_d=3)

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, c(mean, median), Salary, c(Gender,Dept), out_names=c("MeanSalary", "MedianSalary"))

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, mean, c(Years, Salary), c(Dept, Gender), digits_d=0)

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, mean, c(Years, Salary), Dept, digits_d=2,
     out_names=c("YearsMean", "SalaryMean"), show_n=FALSE)

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, mean, Years)

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, mean, c(Years, Salary), digits_d=2, out_names=c("MeanYear", "MeanSalary"))

## ---------------------------------------------------------------------------------------------------------------------
d <- Read("Mach4", quiet=TRUE)
pivot(d, c(mean,sd,skew,kurtosis), m01:m20)

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, table, m06)

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, table, m06, m07)

## ---------------------------------------------------------------------------------------------------------------------
Prop_test(m06, by=m07, data=d)

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, c(mean,sd,table), m06, c(m07, m10))

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, table, m06, m07, table_prop="row")

## ---------------------------------------------------------------------------------------------------------------------
d <- Read("Employee", quiet=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, quantile, Years, c(Dept, Gender))

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, c(mean,sd,quantile), c(Years,Salary), q_num=5, digits_d=2)

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, mean, Salary, Dept, rows=(Gender=="F"))

## ---------------------------------------------------------------------------------------------------------------------
pivot(d[.(Gender=="F"),], mean, Salary, Dept)

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, mean, Salary, c(Dept, Gender), sort="-")

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, c(mean, median), Salary, c(Gender,Dept), out_names=c("MeanSalary", "MedianSalary"),
      sort="-", sort_var="MeanSalary")

## ---------------------------------------------------------------------------------------------------------------------
a <- pivot(d, mean, Salary, c(Dept, Gender))
Sort(a, by=Salary_mn, direction="-")

## ---------------------------------------------------------------------------------------------------------------------
#d |> pivot(mean, Salary, c(Dept, Gender)) -> a
#a

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, mean, Salary, Dept, Gender)

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, mean, Salary, Dept, c(Gender, Plan))

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, mean, Years, Dept)

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, mean, Years, Dept, na_remove=FALSE)

## ---------------------------------------------------------------------------------------------------------------------
dd <- d[.(!(Gender=="M" & Dept=="SALE")), ]

## ---------------------------------------------------------------------------------------------------------------------
pivot(dd, c(mean,median), Years, c(Dept, Gender), na_by_show=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
pivot(dd, c(mean,median), Years, c(Dept, Gender), na_by_show=FALSE)

## ---------------------------------------------------------------------------------------------------------------------
mnmd = function(x, na.rm=TRUE)  mean(x, na.rm=na.rm) - median(x, na.rm=na.rm)

## ---------------------------------------------------------------------------------------------------------------------
pivot(d, c(mean, median, mnmd), Years, by=Dept)

