% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{find_partition}
\alias{find_partition}
\title{Finds the optimal partition using the Leiden algorithm}
\usage{
find_partition(graph, edge_weights, resolution = 1, niter = 2L)
}
\arguments{
\item{graph}{The igraph graph to define the partition on}

\item{edge_weights}{Vector of edge weights. In weighted graphs, a real number is assigned to each (directed or undirected) edge. Refer to igraph, weighted graphs.}

\item{resolution}{Integer resoluiton parameter controlling communities detected (default=1.0) Higher resolutions lead to more communities, while lower resolutions lead to fewer communities.}

\item{niter}{Number of iterations that the algorithm should be run for (default=2)}
}
\value{
A vector of membership values
}
\description{
Finds the optimal partition using the Leiden algorithm
}
\examples{
library(igraph)
library(leidenAlg)

g <- make_star(10)
E(g)$weight <- seq(ecount(g))
find_partition(g, E(g)$weight)

}
