% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/praise.R
\name{random_phrases_add}
\alias{random_phrases_add}
\title{Add phrases to the bank of random phrases}
\usage{
random_phrases_add(language = "en", praise = NULL, encouragement = NULL)
}
\arguments{
\item{language}{The language of the phrases to be added.}

\item{praise, encouragement}{A vector of praising or encouraging phrases,
including final punctuation.}
}
\value{
Returns the previous custom phrases invisibly when called in the
global setup chunk or interactively. Otherwise, it returns a shiny pre-
rendered chunk.
}
\description{
Augment the random phrases available in \code{\link[=random_praise]{random_praise()}} and
\code{\link[=random_encouragement]{random_encouragement()}} with phrases of your own. Note that these phrases
are added to the existing phrases, rather than overwriting them.
}
\section{Usage in learnr tutorials}{


To add random phrases in a learnr tutorial, you can either include one or
more calls to \code{random_phrases_add()} in your global setup chunk:

\if{html}{\out{<div class="sourceCode">}}\preformatted{```\{r setup, include = FALSE\}`r ''`
library(learnr)
random_phrases_add(
  language = "en",
  praise = "Great work!",
  encouragement = "I believe in you."
)
```
}\if{html}{\out{</div>}}

Alternatively, you can call \code{random_phrases_add()} in a separate, standard
R chunk (with \code{echo = FALSE}):

\if{html}{\out{<div class="sourceCode">}}\preformatted{```\{r setup-phrases, echo = FALSE\}`r ''`
random_phrases_add(
  language = "en",
  praise = c("Great work!", "You're awesome!"),
  encouragement = c("I believe in you.", "Yes we can!")
)
```
}\if{html}{\out{</div>}}
}

\examples{
random_phrases_add("demo", praise = "Great!", encouragement = "Try again.")
random_praise(language = "demo")
random_encouragement(language = "demo")


}
