% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lp_get_wrapper.R
\name{lp_get_wrapper}
\alias{lp_get_wrapper}
\alias{lp_post_wrapper}
\title{Leanpub Wrapper for GET/POST statements}
\usage{
lp_get_wrapper(slug, endpoint, api_key = NULL, secure = TRUE,
  verbose = TRUE, ...)

lp_post_wrapper(slug, endpoint, api_key = NULL, secure = TRUE,
  verbose = TRUE, ...)
}
\arguments{
\item{slug}{slug of the project}

\item{endpoint}{call to the api endpoint}

\item{api_key}{API key for Leanpub, passed to \code{\link{lp_api_key}}}

\item{secure}{passed to \code{\link{lp_base_url}} for https}

\item{verbose}{print diagnostic messages}

\item{...}{additional options to pass to \code{\link{GET}}}
}
\value{
List of the result of the \code{\link{GET}} call and
the content
}
\description{
Leanpub Wrapper for GET/POST statements
}
\note{
See \url{https://leanpub.com/help/api}
}
\examples{
if (lp_have_api_key()) {
stat = lp_get_wrapper(slug = "neuroimagingforstatisticians",
    endpoint = "/job_status", nonstop = TRUE, error = FALSE)
}
}
