% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addGeoRaster.R
\name{addCOG}
\alias{addCOG}
\title{Add Cloud Optimised Geotiff (COG) to a leaflet map.}
\usage{
addCOG(
  map,
  url = NULL,
  group = NULL,
  layerId = NULL,
  resolution = 96,
  opacity = 0.8,
  options = leaflet::tileOptions(),
  colorOptions = NULL,
  pixelValuesToColorFn = NULL,
  autozoom = TRUE,
  rgb = FALSE,
  ...
)
}
\arguments{
\item{map}{the map to add the COG to.}

\item{url}{url to the COG file to render.}

\item{group}{he name of the group this COG should belong to.}

\item{layerId}{the layerId.}

\item{resolution}{the target resolution for the simple nearest neighbor
interpolation. Larger values will result in more detailed rendering,
but may impact performance. Default is 96 (pixels).}

\item{opacity}{image opacity.}

\item{options}{see [leaflet](tileOptions).}

\item{colorOptions}{list defining the palette, breaks and na.color to be used.
Currently not used.}

\item{pixelValuesToColorFn}{optional JS function to be passed to the browser.
Can be used to fine tune and manipulate the color mapping.
See examples & \url{https://github.com/r-spatial/leafem/issues/25} for
some examples. Currently not used.}

\item{autozoom}{whether to automatically zoom to the full extent of the layer.
Default is \code{TRUE}.}

\item{rgb}{logical, whether to render Geotiff as RGB. Currently not used.}

\item{...}{currently not used.}
}
\value{
A leaflet map object.
}
\description{
Add Cloud Optimised Geotiff (COG) to a leaflet map.
}
\details{
This function will overlay Cloud Optimised Geotiff data from a remote url on
a leaflet map. Like `addGeotiff` it uses the leaflet plugin
'georaster-layer-for-leaflet' to render the data. See `addGeotiff` for a bit
more detail what that means.
}
\examples{
if (interactive()) {
  library(leaflet)
  library(leafem)

  base_url = "https://sentinel-cogs.s3.us-west-2.amazonaws.com"
  image_url = "sentinel-s2-l2a-cogs/46/X/DG/2022/8/S2B_46XDG_20220829_0_L2A/L2A_PVI.tif"
  url = sprintf("\%s/\%s", base_url, image_url)

  leaflet() |>
    addTiles() |>
    leafem:::addCOG(
      url = url
      , group = "COG"
      , resolution = 512
      , autozoom = TRUE
    )
}

}
