# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Log-likelihood computation
#' 
#' Compute the log-likelihood for the drift-diffusion model, including the
#' censored data contribution.
#'
#' @param tau vector of size n containing the response times
#' @param mu matrix of size (n x d1) containing the drift parameters 
#' corresponding to the n response times for each possible d1 decision
#' @param b matrix of size (n x d1) containing the boundary parameters 
#' corresponding to the n response times for each possible d1 decision
#' @param delta vector of size n containing the offset parameters corresponding
#' to the n response times
#' @param cens vector of size n containing censoring indicators (1 censored, 0
#' not censored) corresponding to the n response times
#' @param D (n x 2) matrix whose first column has the n input stimuli, and whose second column has the n decision categories
#' @param log should the results be returned on the log scale?
log_likelihood <- function(tau, mu, b, delta, cens, D, log) {
    .Call(`_lddmm_log_likelihood`, tau, mu, b, delta, cens, D, log)
}

table_int <- function(x, K) {
    .Call(`_lddmm_table_int`, x, K)
}

sum_rows_log <- function(Q) {
    .Call(`_lddmm_sum_rows_log`, Q)
}

normalise_log <- function(x) {
    .Call(`_lddmm_normalise_log`, x)
}

rdirichlet <- function(deltas) {
    .Call(`_lddmm_rdirichlet`, deltas)
}

count_assign <- function(z, M) {
    .Call(`_lddmm_count_assign`, z, M)
}

sample_reff_mu <- function(tau, D, cens, beta_u_old, delta_dat, b_dat, B_beta_dat, mu_dat_old, B, P, ind, time, sigma2_us, sigma2_ua, sd_beta_u, acc_beta_u) {
    .Call(`_lddmm_sample_reff_mu`, tau, D, cens, beta_u_old, delta_dat, b_dat, B_beta_dat, mu_dat_old, B, P, ind, time, sigma2_us, sigma2_ua, sd_beta_u, acc_beta_u)
}

sample_reff_b <- function(tau, D, cens, beta_u_old, delta_dat, B_beta_dat, b_dat_old, mu_dat, B, P, ind, time, sigma2_us, sigma2_ua, sd_beta_u, acc_beta_u) {
    .Call(`_lddmm_sample_reff_b`, tau, D, cens, beta_u_old, delta_dat, B_beta_dat, b_dat_old, mu_dat, B, P, ind, time, sigma2_us, sigma2_ua, sd_beta_u, acc_beta_u)
}

