% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial_sort.R
\name{partial_sort}
\alias{partial_order}
\alias{partial_sort}
\title{Partial sort an lvec}
\usage{
partial_sort(x, pivots, clone = TRUE)

partial_order(x, pivots)
}
\arguments{
\item{x}{an object of type \code{\link{lvec}}}

\item{pivots}{a numeric vector with indices at which the vector will be 
sorted. See details for more information.}

\item{clone}{clone the vector first before sorting; or sort (and therefore
modify) the input vector directly.}
}
\description{
Partial sort an lvec
}
\details{
After partial sorting the vector values at the pivots are the same as the
vector values of a completely sorted vector. Furthermore, for each pivot
\code{i} all elements \code{x[j]; j < i} are smaller or equal to than 
\code{x[i]} and all elements \code{x[j]; j > i} are larger than or equal to
\code{x[i]}.

The speed of this operation should be O(n, k) with n the size of the 
\code{lvec}  and k the number of pivots.
}
\examples{
x <- as_lvec(rnorm(100))
y <- partial_sort(x, c(10, 50, 90))
x_sorted <- sort(x)
stopifnot(all(y[c(10, 50, 90)] == x_sorted[c(10, 50, 90)]))
stopifnot(max(y[1:9]) <= min(y[11:100]))
stopifnot(max(y[1:49]) <= min(y[51:100]))
stopifnot(max(y[1:89]) <= min(y[91:100]))

}

