% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ismev_refits.R
\name{ismev_refits}
\alias{ismev_refits}
\alias{gev_refit}
\alias{gpd_refit}
\alias{pp_refit}
\alias{rlarg_refit}
\title{Maximum-likelihood (Re-)Fitting using the ismev package}
\usage{
gev_refit(
  xdat,
  ydat = NULL,
  mul = NULL,
  sigl = NULL,
  shl = NULL,
  mulink = identity,
  siglink = identity,
  shlink = identity,
  muinit = NULL,
  siginit = NULL,
  shinit = NULL,
  show = TRUE,
  method = "Nelder-Mead",
  maxit = 10000,
  ...
)

gpd_refit(
  xdat,
  threshold,
  npy = 365,
  ydat = NULL,
  sigl = NULL,
  shl = NULL,
  siglink = identity,
  shlink = identity,
  siginit = NULL,
  shinit = NULL,
  show = TRUE,
  method = "Nelder-Mead",
  maxit = 10000,
  ...
)

pp_refit(
  xdat,
  threshold,
  npy = 365,
  ydat = NULL,
  mul = NULL,
  sigl = NULL,
  shl = NULL,
  mulink = identity,
  siglink = identity,
  shlink = identity,
  muinit = NULL,
  siginit = NULL,
  shinit = NULL,
  show = TRUE,
  method = "Nelder-Mead",
  maxit = 10000,
  ...
)

rlarg_refit(
  xdat,
  r = dim(xdat)[2],
  ydat = NULL,
  mul = NULL,
  sigl = NULL,
  shl = NULL,
  mulink = identity,
  siglink = identity,
  shlink = identity,
  muinit = NULL,
  siginit = NULL,
  shinit = NULL,
  show = TRUE,
  method = "Nelder-Mead",
  maxit = 10000,
  ...
)
}
\arguments{
\item{xdat}{A numeric vector of data to be fitted.}

\item{ydat}{A matrix of covariates for generalized linear modelling
    of the parameters (or \code{NULL} (the default) for stationary
    fitting). The number of rows should be the same as the length
    of \code{xdat}.}

\item{mul}{Numeric vectors of integers, giving the columns
    of \code{ydat} that contain covariates for generalized linear
    modelling of the location, scale and shape parameters repectively
    (or \code{NULL} (the default) if the corresponding parameter is
    stationary).}

\item{sigl}{Numeric vectors of integers, giving the columns
    of \code{ydat} that contain covariates for generalized linear
    modelling of the location, scale and shape parameters repectively
    (or \code{NULL} (the default) if the corresponding parameter is
    stationary).}

\item{shl}{Numeric vectors of integers, giving the columns
    of \code{ydat} that contain covariates for generalized linear
    modelling of the location, scale and shape parameters repectively
    (or \code{NULL} (the default) if the corresponding parameter is
    stationary).}

\item{mulink}{Inverse link functions for generalized
    linear modelling of the location, scale and shape parameters
    repectively.}

\item{siglink}{Inverse link functions for generalized
    linear modelling of the location, scale and shape parameters
    repectively.}

\item{shlink}{Inverse link functions for generalized
    linear modelling of the location, scale and shape parameters
    repectively.}

\item{muinit}{numeric of length equal to total number
    of parameters used to model the location, scale or shape parameter(s),
    resp.  See Details section for default (NULL) initial values.}

\item{siginit}{numeric of length equal to total number
    of parameters used to model the location, scale or shape parameter(s),
    resp.  See Details section for default (NULL) initial values.}

\item{shinit}{numeric of length equal to total number
    of parameters used to model the location, scale or shape parameter(s),
    resp.  See Details section for default (NULL) initial values.}

\item{show}{Logical; if \code{TRUE} (the default), print details of
    the fit.}

\item{method}{The optimization method (see \code{\link{optim}} for
    details).}

\item{maxit}{The maximum number of iterations.}

\item{...}{Other control parameters for the optimization. These
    are passed to components of the \code{control} argument of
    \code{optim}.}

\item{threshold}{The threshold; a single number or a numeric
    vector of the same length as \code{xdat}.}

\item{npy}{The number of observations per year/block.}

\item{r}{The largest \code{r} order statistics are used for
    the fitted model.}
}
\description{
These are a slightly modified versions of the \code{\link[ismev]{gev.fit}},
\code{\link[ismev]{gpd.fit}}, \code{\link[ismev]{pp.fit}} and
\code{\link[ismev]{rlarg.fit}} functions in the \code{\link[ismev]{ismev}}
package.
The modification is to add to the returned object regression design matrices
for the parameters of the model.  That is,
\code{xdat, ydat, mulink, siglink, shlink} and matrices
\code{mumat, sigmat, shmat} for the location, scale and shape parameters
\code{\link[ismev]{gev.fit}}, \code{\link[ismev]{pp.fit}} and
\code{\link[ismev]{rlarg.fit}}, and \code{xdat},
\code{ydat, siglink, shlink} and matrices \code{sigmat, shmat} for the
scale and shape parameters for \code{\link[ismev]{gpd.fit}}.
}
\examples{
# We need the ismev package
got_ismev <- requireNamespace("ismev", quietly = TRUE)
if (got_ismev) {
  library(ismev)
  fit1 <- gev.fit(revdbayes::portpirie, show = FALSE)
  ls(fit1)
  fit2 <- gev_refit(revdbayes::portpirie, show = FALSE)
  ls(fit2)

  data(rain)
  fit1 <- gpd.fit(rain, 10)
  ls(fit1)
  fit2 <- gpd_refit(rain, 10)
  ls(fit2)

  fit1 <- pp.fit(rain, 10, show = FALSE)
  ls(fit1)
  fit2 <- pp_refit(rain, 10, show = FALSE)
  ls(fit2)

  data(venice)
  fit1 <- rlarg.fit(venice[, -1], muinit = 120.54, siginit = 12.78,
                   shinit = -0.1129, show = FALSE)
  ls(fit1)
  fit2 <- rlarg_refit(venice[, -1], muinit = 120.54, siginit = 12.78,
                   shinit = -0.1129, show = FALSE)
  ls(fit2)
}
}
\references{
Heffernan, J. E. and Stephenson, A. G. (2018). ismev: An
  Introduction to Statistical Modeling of Extreme Values.
  R package version 1.42.
  \url{https://CRAN.R-project.org/package=ismev}.
}
