% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlm.test.R
\name{rlm.test}
\alias{rlm.test}
\title{Robust L1 Moment-Based (RLM) Goodness-of-Fit Test for the Laplace Distribution}
\usage{
rlm.test(x, crit.values = c("chisq.approximation", "empirical"), N = 0)
}
\arguments{
\item{x}{a numeric vector of data values.}

\item{crit.values}{a character string specifying how the critical values 
should be obtained: approximated by the Chi-square distribution (default) 
or empirically.}

\item{N}{number of Monte Carlo simulations for the empirical critical values.}
}
\value{
A list of class \code{"htest"} with the following components:
\item{statistic}{the value of the test statistic.}
\item{parameter}{the degrees of freedom.}
\item{p.value}{the \eqn{p}-value of the test.}
\item{method}{type of test was performed.}
\item{data.name}{a character string giving the name of the data.}
}
\description{
Robust test for the Laplace distribution. Two options for calculating critical 
values, namely, approximated with Chi-square distribution and empirical, 
are available.
}
\details{
The test is based on a joint statistic using skewness and kurtosis 
coefficients. In particular, RLM uses the Average Absolute Deviation from the Median 
(MAAD), a robust estimate of standard deviation. See 
\insertCite{Gel_2010;textual}{lawstat}.
}
\examples{
## Laplace distributed data
x = rexp(100) - rexp(100)
rlm.test(x)
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{sj.test}}, \code{\link{rjb.test}}, \code{\link{rqq}}, 
\code{\link[tseries]{jarque.bera.test}}
}
\author{
Kimihiro Noguchi, W. Wallace Hui, Yulia R. Gel
}
\keyword{distribution}
\keyword{htest}
\keyword{robust}
