% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rjb.test.R
\name{rjb.test}
\alias{rjb.test}
\title{Test of Normailty -- Robust Jarque--Bera Test}
\usage{
rjb.test(
  x,
  option = c("RJB", "JB"),
  crit.values = c("chisq.approximation", "empirical"),
  N = 0
)
}
\arguments{
\item{x}{a numeric vector of data values.}

\item{option}{the choice of whether to perform the robust test, \code{"RJB"} 
(default) or classic test, \code{"JB"}.}

\item{crit.values}{a character string specifying how the critical values 
should be obtained: approximated by the Chi-square distribution (default) 
or empirically.}

\item{N}{number of Monte Carlo simulations for the empirical critical values.}
}
\value{
A list of class \code{"htest"} with the following components:
\item{statistic}{the value of the test statistic.}
\item{parameter}{the degrees of freedom.}
\item{p.value}{the \eqn{p}-value of the test.}
\item{method}{type of test was performed.}
\item{data.name}{a character string giving the name of the data.}
}
\description{
The robust and classical Jarque--Bera tests of normality.
}
\details{
The test is based on a joint statistic using skewness and kurtosis
coefficients. The Robust Jarque--Bera (RJB) is the robust version of
the Jarque--Bera (JB) test of normality. The RJB (default option) utilizes
the robust standard deviation (specifically, 
the Average Absolute Deviation from the Median; MAAD) 
to estimate sample kurtosis and skewness. For more details, see 
\insertCite{Gel_Gastwirth_2008;textual}{lawstat}. Users can also choose to 
perform the classical Jarque--Bera test \insertCite{Jarque_Bera_1980}{lawstat}.
}
\note{
Modified from \code{\link[tseries]{jarque.bera.test}} 
(\code{tseries} package).
}
\examples{
## Normally distributed data
x = rnorm(100)
rjb.test(x)

## Using zuni data
data(zuni)
rjb.test(zuni[, "Revenue"])

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{sj.test}}, \code{\link{rqq}}, 
\code{\link[tseries]{jarque.bera.test}}
}
\author{
W. Wallace Hui, Yulia R. Gel, Joseph L. Gastwirth, Weiwen Miao
}
\keyword{distribution}
\keyword{htest}
\keyword{robust}
