% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmh.test.R
\name{cmh.test}
\alias{cmh.test}
\title{The Cochran-Mantel-Haenszel Chi-square Test}
\usage{
cmh.test(x)
}
\arguments{
\item{x}{a numeric \eqn{2 \times 2 \times k} array of data values.}
}
\value{
A list of class \code{"htest"} containing the following components:
\item{MH.ESTIMATE}{the value of the Cochran--Mantel--Haenszel estimate.}
\item{OR}{pooled Odd Ratio of the data.}
\item{ORK}{vector of Odd Ratio of each level.}
\item{cmh}{the test statistic.}
\item{df}{degrees of freedom.}
\item{p.value}{the \eqn{p}-value of the test.}
\item{method}{type of the performed test.}
\item{data.name}{a character string giving the name of the data.}
}
\description{
The Cochran--Mantel--Haenszel (CMH) procedure tests homogeneity of population 
proportions after taking into account other factors. This procedure is widely 
used in law cases, for example, on equal employment and discrimination, 
and in biological and phamaceutical studies.
}
\details{
The test is based on the CMH procedure discussed 
by \insertCite{Gastwirth_1984;textual}{lawstat}. The data should be input in an array 
of 2 rows \eqn{\times} 2 columns \eqn{\times} \eqn{k} levels. 
The output includes the Mantel--Haenszel Estimate, the pooled Odd Ratio, 
and the Odd Ratio between the rows and columns at each level. The Chi-square 
test of significance tests if there is an interaction or association 
between rows and columns.

The null hypothesis is that the pooled Odd Ratio is equal to 1, i.e., 
there is no interaction between rows and columns. For more details see 
\insertCite{Gastwirth_1984;textual}{lawstat}.

The \code{cmh.test} can be viewed as a subset of 
\code{\link[stats]{mantelhaen.test}}, in the sense that \code{cmh.test} is for a 
2 by 2 by \eqn{k} table without continuity correction, whereas 
\code{\link[stats]{mantelhaen.test}} allows for a larger table, 
and for a 2 by 2 by \eqn{k} table, it has an option of performing continuity correction. 
However, in view of \insertCite{Gastwirth_1984;textual}{lawstat}, continuity 
correction is not recommended as it tends to overestimate the \eqn{p}-value.
}
\examples{
## Sample Salary Data
data(blackhire)
cmh.test(blackhire)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[stats]{mantelhaen.test}}
}
\author{
Min Qin, Wallace W. Hui, Yulia R. Gel, Joseph L. Gastwirth
}
\keyword{homogeneity}
\keyword{htest}
