% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/square.R
\name{lawn_square}
\alias{lawn_square}
\title{Calculate a square bounding box}
\usage{
lawn_square(bbox)
}
\arguments{
\item{bbox}{A bounding box.}
}
\value{
A square surrounding bbox, numeric vector of length four.
}
\description{
Takes a bounding box and calculates the minimum square bounding
box that would contain the input.
}
\examples{
bbox <- c(-20, -20, -15, 0)
lawn_square(bbox)
\dontrun{
sq <- lawn_square(bbox)
lawn_featurecollection(list(lawn_bbox_polygon(bbox),
  lawn_bbox_polygon(sq))) \%>\% view
}
}
\seealso{
Other measurements: \code{\link{lawn_along}},
  \code{\link{lawn_area}}, \code{\link{lawn_bbox_polygon}},
  \code{\link{lawn_bbox}}, \code{\link{lawn_bearing}},
  \code{\link{lawn_center_of_mass}},
  \code{\link{lawn_center}}, \code{\link{lawn_centroid}},
  \code{\link{lawn_destination}},
  \code{\link{lawn_distance}}, \code{\link{lawn_envelope}},
  \code{\link{lawn_extent}},
  \code{\link{lawn_line_distance}},
  \code{\link{lawn_midpoint}},
  \code{\link{lawn_point_on_surface}},
  \code{\link{lawn_pt2line_distance}}
}
