% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multipoint.R
\name{lawn_multipoint}
\alias{lawn_multipoint}
\title{MultiPoint}
\usage{
lawn_multipoint(coordinates, properties = NULL)
}
\arguments{
\item{coordinates}{A list of point pairs, either as a list or json, of the
form e.g. \code{list(c(longitude, latitude), c(longitude, latitude))} or
as JSON e.g. \code{[[longitude, latitude], [longitude, latitude]]}.}

\item{properties}{A list of properties. Default: \code{NULL}}
}
\value{
A \link{data-Feature}<(\link{data-MultiPoint})>
}
\description{
Create a multipoint
}
\examples{
lawn_multipoint(list(c(-74.5, 40), c(-77.5, 45)))
lawn_multipoint("[[-74.5,40],[-77.5,45]]")
identical(
  lawn_multipoint(list(c(-74.5, 40), c(-77.5, 45))),
  lawn_multipoint("[[-74.5,40],[-77.5,45]]")
)
lawn_multipoint("[[-74.5,40],[-77.5,45]]",
  properties = list(city = 'Boston', population = 400))

# Make a FeatureCollection
lawn_featurecollection(
  lawn_multipoint(list(c(-74.5, 40), c(-77.5, 45)))
)
}
\seealso{
Other data functions: \code{\link{lawn_featurecollection}},
  \code{\link{lawn_feature}}, \code{\link{lawn_filter}},
  \code{\link{lawn_geometrycollection}},
  \code{\link{lawn_linestring}},
  \code{\link{lawn_multilinestring}},
  \code{\link{lawn_multipolygon}},
  \code{\link{lawn_point}}, \code{\link{lawn_polygon}},
  \code{\link{lawn_random}}, \code{\link{lawn_remove}},
  \code{\link{lawn_sample}}
}
