% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/erase.R
\name{lawn_erase}
\alias{lawn_erase}
\title{Erase one polygon from another}
\usage{
lawn_erase(poly1, poly2, lint = FALSE)
}
\arguments{
\item{poly1}{input Polygon feaure}

\item{poly2}{Polygon feature to erase from poly1}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing time
as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good geojson
objects. Default: \code{FALSE}}
}
\value{
a \code{\link{data-Polygon}} feature showing the area of poly1 excluding
the area of poly2
}
\description{
Finds the difference between two \code{\link{data-Polygon}}'s by clipping
the second polygon from the first.
}
\examples{
poly1 <- '{
 "type": "Feature",
  "properties": {
    "fill": "#0f0"
  },
  "geometry": {
    "type": "Polygon",
    "coordinates": [[
      [-46.738586, -23.596711],
      [-46.738586, -23.458207],
      [-46.560058, -23.458207],
      [-46.560058, -23.596711],
      [-46.738586, -23.596711]
    ]]
  }
}'

poly2 <- '{
  "type": "Feature",
  "properties": {
    "fill": "#00f"
  },
  "geometry": {
    "type": "Polygon",
    "coordinates": [[
      [-46.650009, -23.631314],
      [-46.650009, -23.5237],
      [-46.509246, -23.5237],
      [-46.509246, -23.631314],
      [-46.650009, -23.631314]
    ]]
  }
}'
lawn_erase(poly1, poly2)
}
\seealso{
Other transformations: \code{\link{lawn_bezier}},
  \code{\link{lawn_buffer}}, \code{\link{lawn_concave}},
  \code{\link{lawn_convex}}, \code{\link{lawn_intersect}},
  \code{\link{lawn_merge}}, \code{\link{lawn_simplify}},
  \code{\link{lawn_union}}
}

