% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sCorrect-skeleton.R
\name{skeleton}
\alias{skeleton}
\alias{skeletonDtheta}
\alias{skeletonDtheta2}
\title{Pre-computation for the Score}
\usage{
skeleton(object, X, endogenous, latent, n.cluster, index.Omega)

skeletonDtheta(
  object,
  X,
  endogenous,
  latent,
  missing.pattern,
  unique.pattern,
  name.pattern,
  n.cluster,
  index.Omega
)

skeletonDtheta2(object)
}
\arguments{
\item{object}{a \code{lvm} object.}

\item{X}{[matrix] design matrix containing the covariates for each endogeneous and latent variable.}

\item{latent}{[character vector] the name of the latent variables.}

\item{endogeneous}{[character vector] the name of the endogeneous variables.}

\item{...}{[internal] only used by the generic method.}
}
\description{
Pre-compute quantities that are necessary to compute the score of a lvm model.
}
\details{
When the user specifies names for the coefficients (e.g. Y1[mu:sigma]) or uses constraints (Y1~beta*X1), \code{as.lava=FALSE} will use the names specified by the user (e.g. mu, sigma, beta)
while \code{as.lava=TRUE} will use the name of the first link defining the coefficient.
}
\examples{
\dontrun{
skeleton <- lavaSearch2::skeleton
skeleton.lvm <- lavaSearch2::skeleton.lvm
skeleton.lvmfit <- lavaSearch2::skeleton.lvmfit

## without constrain
m <- lvm(Y1~X1+X2+eta,Y2~X3+eta,Y3~eta)
latent(m) <- ~eta

e <- estimate(m, lava::sim(m,1e2))
M.data <- as.matrix(model.frame(e))

skeleton(e$model, as.lava = TRUE,
         name.endogenous = endogenous(e), n.endogenous = 3,
         name.latent = latent(e), 
         update.value = FALSE)
skeleton(e, data = M.data, p = pars(e), as.lava = TRUE,
         name.endogenous = endogenous(e), n.endogenous = 3,
         name.latent = latent(e), 
         update.value = TRUE)

## with constrains
m <- lvm(Y[mu:sigma] ~ beta*X1+X2)
e <- estimate(m, lava::sim(m,1e2))
M.data <- as.matrix(model.frame(e))

skeleton(e$model, as.lava = TRUE,
         name.endogenous = "Y", n.endogenous = 1,
         name.latent = NULL, 
         update.value = FALSE)$skeleton

skeleton(e, data = M.data, p = pars(e), as.lava = FALSE,
         name.endogenous = "Y", n.endogenous = 1,
         name.latent = NULL, 
         update.value = FALSE)$skeleton

}
}
\concept{derivative of the score equation}
\concept{small sample inference}
\keyword{internal}
