% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelsearch2.R
\name{modelsearch2}
\alias{modelsearch2}
\alias{modelsearch2.lvmfit}
\title{Data-driven Extension of a Latent Variable Model}
\usage{
modelsearch2(object, link, data, method.p.adjust, type.information, alpha,
  nStep, na.omit, trace, cpus)

\method{modelsearch2}{lvmfit}(object, link = NULL, data = NULL,
  method.p.adjust = "fastmax", type.information = "E", alpha = 0.05,
  nStep = NULL, na.omit = TRUE, trace = TRUE, cpus = 1)
}
\arguments{
\item{object}{a \code{lvmfit} object.}

\item{link}{[character, optional for \code{lvmfit} objects] the name of the additional relationships to consider when expanding the model. Should be a vector containing strings like "Y~X". See the details section.}

\item{data}{[data.frame, optional] the dataset used to identify the model}

\item{method.p.adjust}{[character] the method used to adjust the p.values for multiple comparisons.
Can be any method that is valid for the \code{stats::p.adjust} function (e.g. \code{"fdr"}), or \code{"max"} or \code{"fastmax"}.}

\item{type.information}{[character] the method used by \code{lava::information} to compute the information matrix.}

\item{alpha}{[numeric 0-1] the significance cutoff for the p-values.
When the p-value is below, the corresponding link will be added to the model
and the search will continue. Otherwise the search will stop.}

\item{nStep}{the maximum number of links that can be added to the model.}

\item{na.omit}{should tests leading to NA for the test statistic be ignored. Otherwise this will stop the selection process.}

\item{trace}{[logical] should the execution of the function be traced?}

\item{cpus}{the number of cpus that can be used for the computations.}
}
\value{
A list containing:
\itemize{
\item sequenceTest: the sequence of test that has been performed.
\item sequenceModel: the sequence of models that has been obtained.
\item sequenceQuantile: the sequence of rejection threshold. Optional. 
\item sequenceIID: the influence functions relative to each test. Optional. 
\item sequenceSigma: the covariance matrix relative to each test. Optional. 
\item initialModel: the model before the sequential search.
\item statistic: the argument \code{statistic}.
\item method.p.adjust: the argument \code{method.p.adjust}.
\item alpha: [numeric 0-1] the significance cutoff for the p-values.
\item cv: whether the procedure has converged.
}
}
\description{
Procedure adding relationship between variables that are supported by the data.
}
\details{
method.p.adjust = \code{"max"} computes the p-values based on the distribution of the max statistic.
This max statistic is the max of the square root of the score statistic.
The p-value are computed integrating the multivariate normal distribution.

method.p.adjust = \code{"fastmax"} only compute the p-value for the largest statistic.
It is faster than \code{"max"} and lead to identical results.
}
\examples{

## simulate data
mSim <- lvm()
regression(mSim) <- c(y1,y2,y3,y4)~u
regression(mSim) <- u~x1+x2
categorical(mSim,labels=c("A","B","C")) <- "x2"
latent(mSim) <- ~u
covariance(mSim) <- y1~y2
transform(mSim, Id~u) <- function(x){1:NROW(x)}
df.data <- lava::sim(mSim, n = 1e2, latent = FALSE)

## only identifiable extensions
m <- lvm(c(y1,y2,y3,y4)~u)
latent(m) <- ~u
addvar(m) <- ~x1+x2

e <- estimate(m, df.data)

\dontrun{
resSearch <- modelsearch(e)
resSearch

resSearch2 <- modelsearch2(e, nStep = 2)
resSearch2
}
\dontshow{
search.link <- c("u~x1","u~x2","y1~x1","y1~x2","y1~~y2","y1~~y3")
resSearch2 <- modelsearch2(e, nStep = 2, link = search.link)
resSearch2
}

## some extensions are not identifiable
m <- lvm(c(y1,y2,y3)~u)
latent(m) <- ~u
addvar(m) <- ~x1+x2 

e <- estimate(m, df.data)

\dontrun{
resSearch <- modelsearch(e)
resSearch
resSearch2 <- modelsearch2(e)
resSearch2
}

## for instance
mNI <- lvm(c(y1,y2,y3)~u)
latent(mNI) <- ~u
covariance(mNI) <- y1~y2
## estimate(mNI, data = df.data)
## does not converge



}
\concept{modelsearch}
