% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link.R
\name{findNewLink}
\alias{findNewLink}
\alias{findNewLink.lvm}
\title{Find all New Links Between Variables}
\usage{
findNewLink(x, ...)

\method{findNewLink}{lvm}(x, data = NULL, exclude.var = NULL,
  rm.latent_latent = FALSE, rm.endo_endo = FALSE, rm.latent_endo = FALSE,
  output = "names", ...)
}
\arguments{
\item{x}{a lvm model}

\item{...}{additional arguments to be passed to lower levels functions.}

\item{data}{an optional dataset used to identify the categorical variables if not specified in the lvm object.}

\item{exclude.var}{all links related to these variables will be ignore.}

\item{rm.latent_latent}{ignore links relating two latent variables.}

\item{rm.endo_endo}{ignore links relating two endogenous variables}

\item{rm.latent_endo}{ignore links relating one endogenous variable and one latent variable}

\item{output}{return the names of the variables to link ("names") or their position ("index")}
}
\value{
A list
}
\description{
Find all new links between variables (copied from lava::modelsearch).
}
\examples{
library(lava)

m <- lvm()
regression(m) <- c(y1,y2,y3)~u
categorical(m,labels=c("M","F","MF")) <- ~X1
findNewLink(m, rm.endo = FALSE)
findNewLink(m, rm.endo = TRUE)
findNewLink(m, exclude.var = "X1")

regression(m) <- u~x1+x2
latent(m) <- ~u

findNewLink(m, rm.endo = FALSE)
findNewLink(m, rm.endo = TRUE)
findNewLink(m, rm.endo = TRUE, output = "index")
}
