% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spaghetti.R
\name{spaghetti}
\alias{spaghetti}
\title{Spaghetti plot}
\usage{
spaghetti(formula, data, id = "id", group = NULL, type = "l", lty = 1,
  col = 1:10, alpha = 0.3, lwd = 1, trend.formula = formula,
  tau = NULL, trend.lty = 1, trend.join = TRUE, trend.delta = 0.2,
  trend = !is.null(tau), trend.col = col, trend.alpha = 0.2,
  trend.lwd = 3, legend = NULL, xlab = "Time", ylab = "", add = FALSE,
  ...)
}
\arguments{
\item{formula}{Formula (response ~ time)}

\item{data}{data.frame}

\item{id}{Id variable}

\item{group}{group variable}

\item{type}{Type (line 'l', stair 's', ...)}

\item{lty}{Line type}

\item{col}{Colour}

\item{alpha}{transparency (0-1)}

\item{lwd}{Line width}

\item{trend.formula}{Formula for trendline}

\item{tau}{Quantile to estimate (trend)}

\item{trend.lty}{Trend line type}

\item{trend.join}{Trend polygon}

\item{trend.delta}{Trend confidence limits}

\item{trend}{Add trend line}

\item{trend.col}{Colour of trend line}

\item{trend.alpha}{Transparency}

\item{trend.lwd}{Trend line width}

\item{legend}{Legend}

\item{xlab}{Label of X-axis}

\item{ylab}{Label of Y-axis}

\item{add}{Add to existing device}

\item{...}{Additional arguments to lower level arguments}
}
\description{
Spaghetti plot for longitudinal data
}
\examples{
if (interactive() & requireNamespace("mets")) {
K <- 5
y <- "y"\%++\%seq(K)
m <- lvm()
regression(m,y=y,x=~u) <- 1
regression(m,y=y,x=~s) <- seq(K)-1
regression(m,y=y,x=~x) <- "b"
d <- sim(m,500)
dd <- mets::fast.reshape(d);
dd$num <- dd$num+rnorm(nrow(dd),sd=0.5) ## Unbalance
spaghetti(y~num,dd,id="id",lty=1,col=Col(1,.4),trend=TRUE,trend.col="darkblue")
}
}
\author{
Klaus K. Holst
}

