\name{labels<-}
\alias{edgelabels}
\alias{edgelabels<-}
\alias{edgelabels<-.lvm}
\alias{labels}
\alias{labels.graphNEL}
\alias{labels.lvm}
\alias{labels.lvmfit}
\alias{labels<-}
\alias{labels<-.default}
\alias{nodecolor}
\alias{nodecolor<-}
\alias{nodecolor<-.default}
\title{Define labels of graph}
\usage{
  \method{labels}{default}(object, ...) <- value
    \method{edgelabels}{lvm}(object, to, ...) <- value
    \method{nodecolor}{default}(object, var=vars(object),
    border, labcol, shape, lwd, ...) <- value
}
\arguments{
  \item{object}{\code{lvm}-object.}

  \item{value}{node label/edge label/color}

  \item{to}{Formula specifying outcomes and predictors
  defining relevant edges.}

  \item{\dots}{Additional arguments (\code{lwd},
  \code{cex}, \code{col}, \code{labcol}), \code{border}.}

  \item{var}{Formula or character vector specifying the
  nodes/variables to alter.}

  \item{border}{Colors of borders}

  \item{labcol}{Text label colors}

  \item{shape}{Shape of node}

  \item{lwd}{Line width of border}
}
\description{
  Alters labels of nodes and edges in the graph of a latent
  variable model
}
\examples{
m <- lvm(c(y,v)~x+z)
regression(m) <- c(v,x)~z
labels(m) <- c(y=expression(psi), z=expression(zeta))
nodecolor(m,~y+z+x,border=c("white","white","black"), labcol="white", lwd=c(1,1,5)) <- c("orange","indianred","lightgreen")
edgelabels(m,y~z+x, cex=c(2,3), col=c("orange","black"),labcol="darkblue",
lwd=c(3,1)) <- expression(phi,rho)
edgelabels(m,c(v,x)~z, labcol="red", cex=2) <- 2
\donttest{plot(m)}
}
\author{
  Klaus K. Holst
}
\keyword{aplot}
\keyword{graphs}

